/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.core.WideDropDownComboBox;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.geotools.geometry.jts.WKTReader2;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;

public abstract class AGeoHandler {
    private static final Map<Integer, Tuple<GeometryFactory, WKTReader2>> READERS = new HashMap<Integer, Tuple<GeometryFactory, WKTReader2>>();

    protected void adjustCombo(WideDropDownComboBox ... combos) {
        WideDropDownComboBox[] wideDropDownComboBoxArray = combos;
        int n = combos.length;
        int n2 = 0;
        while (n2 < n) {
            WideDropDownComboBox combo = wideDropDownComboBoxArray[n2];
            combo.adjustDropDownMenuWidth();
            ++n2;
        }
    }

    protected List<TextListItem<Integer>> getColumns(IResultSetTable m, boolean addEmpty, GraphHandler.VALUE_TYPE ... types) {
        ArrayList<TextListItem<Integer>> cols = new ArrayList<TextListItem<Integer>>();
        int i = 0;
        while (i < m.getColumnCount()) {
            if (types.length == 0 || ListUtils.in((Object)((Object)GraphHandler.VALUE_TYPE.getFromType(m.getFieldType(i))), (Object[])types)) {
                cols.add(new TextListItem<Integer>(i, m.getColumnName(i)));
            }
            ++i;
        }
        if (cols.size() == 0 || addEmpty) {
            cols.add(0, IGeoSetting.EMPTY_VALUE);
        }
        return cols;
    }

    public static Tuple<GeometryFactory, WKTReader2> getReaderFromSRID(int srid) {
        return READERS.computeIfAbsent(srid, e -> {
            try {
                GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid, (CoordinateSequenceFactory)CoordinateArraySequenceFactory.instance());
                return Tuple.of((Object)geometryFactory, (Object)new WKTReader2(geometryFactory));
            }
            catch (Exception ex) {
                return null;
            }
        });
    }

    public static void setRenderers(JComboBox ... boxes) {
        LabelledCellRenderer cellRenderer = new LabelledCellRenderer(true);
        JComboBox[] jComboBoxArray = boxes;
        int n = boxes.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox box = jComboBoxArray[n2];
            box.setRenderer(cellRenderer);
            ++n2;
        }
    }

    protected int getCountFromResultSet(IResultSetTable table, boolean filtered) {
        if (!filtered) {
            return table.getRowCount();
        }
        ResultSetTableModel rstm = (ResultSetTableModel)table;
        return rstm.getSorter().getViewRowCount();
    }
}

