/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.results.MathBuilder;
import com.sigge.filerunner.view.results.graph.ColorPalette;
import com.sigge.filerunner.view.results.graph.PaletteManager;
import com.sigge.filerunner.view.results.graph.geo.LayerWaypoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.WaypointRenderer;

public class LayerPainter
implements WaypointRenderer<LayerWaypoint> {
    private final double min;
    private final double max;
    private final ColorPalette colormap = PaletteManager.create(100, Arrays.asList(Color.BLACK, Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED), null, 100);
    private final Map<Integer, Map<Integer, Avg>> map = new HashMap<Integer, Map<Integer, Avg>>();
    private int lastZoom = -1;

    public LayerPainter(MathBuilder mb) {
        this.min = mb.min() == null ? 0.0 : mb.min();
        this.max = mb.max() == null ? 0.0 : mb.max();
    }

    public void paintWaypoint(Graphics2D g, JXMapViewer viewer, LayerWaypoint w) {
        if (this.lastZoom != viewer.getZoom()) {
            this.map.clear();
            this.lastZoom = viewer.getZoom();
        }
        Point2D point = viewer.getTileFactory().geoToPixel(w.getPosition(), viewer.getZoom());
        int x = (int)point.getX();
        int y = (int)point.getY();
        Double heat = w.getLayerValue();
        Avg a = this.map.computeIfAbsent(x, z -> new HashMap()).computeIfAbsent(y, z -> new Avg());
        a.agg(heat);
        if (heat == null) {
            return;
        }
        double avg = a.avg();
        int i = (int)(100.0 * (avg - this.min) / (this.max - this.min == 0.0 ? 1.0 : this.max - this.min));
        if (i == 100) {
            --i;
        }
        if (i < 0) {
            System.out.println(i);
        }
        g.setColor(this.colormap.getColor((double)i * 1.0));
        g.fillRect(x, y, 1, 1);
    }

    class Avg {
        double sum = 0.0;
        double count = 0.0;

        Avg() {
        }

        void agg(Double value) {
            if (value != null) {
                this.sum += value.doubleValue();
                this.count += 1.0;
            }
        }

        double avg() {
            return this.count > 0.0 ? this.sum / this.count : 0.0;
        }
    }
}

