/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.MathBuilder;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.geo.IGeoManager;
import com.sigge.filerunner.view.results.graph.geo.options.FromToGeo;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoTypeHandler;
import com.sigge.filerunner.view.results.graph.geo.options.IconView;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeo;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ChangeListener;
import java.awt.CardLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class Geoset2
implements ILabel {
    private final List<Binder.Presenter<TextListItem<Integer>>> presenters = new ArrayList<Binder.Presenter<TextListItem<Integer>>>();
    private Binder.Presenter<GeoType> iconCombo;
    private JPanel holder;
    private final Container container;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final String id;
    private IGeoSetting geo;
    private final IGeoManager manager;

    public Geoset2(Container container, List<GraphResult> results, GraphResult previous, Optional<IGeoSetting> previousGraph, IGeoManager manager) {
        this(container, results, previous, previousGraph, null, manager);
    }

    public Geoset2(Container container, List<GraphResult> results, GraphResult previous, Optional<IGeoSetting> previousGraph, String id, IGeoManager manager) {
        this.container = container;
        this.id = id;
        this.manager = manager;
        this.create(results, previous, previousGraph, previousGraph.map(IGeoSetting::getType).orElse(GeoType.WAYPOINT), id);
        if (previousGraph.isPresent()) {
            IGeoSetting setting = previousGraph.get();
            GeoType icon = setting.getType();
            ((JComboBox)this.iconCombo.getBound()).setSelectedItem(icon);
        }
    }

    public SingleGeo getAsSingleGeo() {
        return (SingleGeo)this.geo;
    }

    public FromToGeo getAsTripGeo() {
        return (FromToGeo)this.geo;
    }

    private void create(List<GraphResult> results, GraphResult previous, Optional<IGeoSetting> initial, GeoType type, String id) {
        if (this.holder != null) {
            this.removeSet();
        }
        this.holder = new JPanel();
        this.holder.setLayout(new BoxLayout(this.holder, 1));
        this.container.remove(this.holder);
        this.container.add(id, this.holder);
        IconView iv = new IconView();
        iv.getVisLabel().setText("Visualize #" + id + ":");
        this.iconCombo = Binder.bindToCombo(iv.getIconCombo(), Arrays.asList(GeoType.WAYPOINT, GeoType.HEATMAP, GeoType.TRIP));
        this.holder.add(iv);
        this.createSpace();
        ((JComboBox)this.iconCombo.getBound()).setSelectedItem(type);
        IGeoTypeHandler<IGeoSetting> h = type.getHandler();
        this.geo = h.create(this.manager, this.holder, results, previous, initial, this::runListeners, id);
        iv.getIconCombo().addActionListener(e -> {
            if (this.iconCombo.getValue() != this.geo.getType()) {
                this.create(results, previous, this.manager.loadPrevious(previous, Optional.ofNullable((GeoType)this.iconCombo.getValue())), (GeoType)this.iconCombo.getValue(), id);
                if (this.container.getLayout() instanceof CardLayout && id != null) {
                    ((CardLayout)this.container.getLayout()).show(this.container, id);
                }
            }
        });
        this.holder.revalidate();
        this.refreshListeners();
    }

    private void createSpace() {
        this.holder.add(Box.createVerticalStrut(5));
    }

    public Optional<GeoType> getType() {
        return Optional.of((GeoType)this.iconCombo.getValue());
    }

    public IGeoSetting getSettings() {
        return this.geo;
    }

    public void removeSet() {
        Container parent = this.holder.getParent();
        parent.remove(this.holder);
        this.presenters.clear();
    }

    private void runListeners() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.changed();
        }
    }

    public void addModelListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
        this.iconCombo.getModel().addModelChangeListener(changeListener);
    }

    private void refreshListeners() {
        for (ChangeListener changeListener : this.changeListeners) {
            this.iconCombo.getModel().addModelChangeListener(changeListener);
        }
    }

    public MathBuilder getMathBuilder() {
        return this.geo.getMathBuilder().get();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.id;
    }
}

