/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.results.graph.geo.FromToWaypoint;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import java.util.Optional;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Waypoint;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class GeoUtils {
    public static Optional<GeoPosition> getPositionFromWaypoint(Waypoint gww) {
        FromToWaypoint ftt;
        if (gww == null) {
            return Optional.empty();
        }
        if (gww.getPosition() != null) {
            return Optional.of(gww.getPosition());
        }
        if (gww instanceof GeoWaypoint) {
            Point p;
            Geometry geomm = ((GeoWaypoint)gww).getGeometry();
            if (geomm != null && (p = geomm.getCentroid()) != null) {
                return Optional.of(new GeoPosition(p.getCoordinate().y, p.getCoordinate().x));
            }
        } else if (gww instanceof FromToWaypoint && (ftt = (FromToWaypoint)gww).getTo() != null) {
            return GeoUtils.getPositionFromWaypoint(ftt.getTo());
        }
        return Optional.empty();
    }
}

