/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.view.results.graph.geo.IMultipointRenderer;
import com.sigge.filerunner.view.results.graph.geo.SelectionAdapter;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.siggemannen.core.ThreadUtils;
import com.siggemannen.core.Tuple;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.AbstractPainter;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointRenderer;

public class GeoPainter
extends AbstractPainter<JXMapViewer> {
    private static final int MAX_LAT = 90;
    private static final int MIN_LAT = -90;
    private static final int MAX_LON = 360;
    private static final int MIN_LON = -360;
    private final List<Tuple<WaypointRenderer, WaypointHolder<Waypoint>>> WP = new ArrayList<Tuple<WaypointRenderer, WaypointHolder<Waypoint>>>();
    private final Color fillColor = new Color(128, 192, 255, 128);
    private final Color frameColor = new Color(0, 0, 255, 128);
    private final Color gridColor = new Color(0, 0, 255, 40);
    private final Color gridColorRed = new Color(255, 0, 0, 80);
    private final SelectionAdapter adapter;
    private boolean centered = false;
    private Waypoint centerPoint;

    public GeoPainter(SelectionAdapter adapter) {
        this.setAntialiasing(true);
        this.setCacheable(false);
        this.adapter = adapter;
    }

    public void addWaypoints(WaypointRenderer renderer, WaypointHolder wp) {
        this.WP.add((Tuple<WaypointRenderer, WaypointHolder<Waypoint>>)Tuple.of((Object)renderer, (Object)wp));
    }

    public void setCenter(Waypoint centerPoint) {
        this.centerPoint = centerPoint;
        this.centered = false;
    }

    public void clear() {
        this.WP.forEach(e -> ((WaypointHolder)e.second()).getWaypoints().clear());
        this.WP.clear();
        this.centerPoint = null;
    }

    protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Point2D point;
        Point2D prev;
        if (this.WP.isEmpty()) {
            return;
        }
        if (this.centerPoint != null && !this.centered && this.centerPoint.getPosition() != null) {
            if (this.centerPoint.getPosition() != null) {
                map.setAddressLocation(this.centerPoint.getPosition());
            } else {
                map.setAddressLocation(new GeoPosition(0.0, 0.0));
            }
            this.centered = true;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        this.doPaintInternal(g2, map, width, height);
        g2.dispose();
        Tuple<Rectangle, List<GeoPosition>> tuple = this.adapter.getRectangle();
        Rectangle rc = (Rectangle)tuple.first();
        List second = (List)tuple.second();
        if (rc != null) {
            g.setColor(this.frameColor);
            g.draw(rc);
            g.setColor(this.fillColor);
            g.fill(rc);
        }
        Rectangle viewportBounds = map.getViewportBounds();
        g2 = (Graphics2D)g.create();
        g2.setColor(this.gridColor);
        g2.translate(-viewportBounds.getX(), -viewportBounds.getY());
        if (second != null) {
            Point2D prev2 = null;
            int i = 0;
            while (i < second.size()) {
                GeoPosition geo = (GeoPosition)second.get(i);
                Point2D point2 = map.getTileFactory().geoToPixel(geo, map.getZoom());
                g2.setColor(Color.BLACK);
                g2.fillRect((int)point2.getX() - 2, (int)point2.getY() - 2, 4, 4);
                if (prev2 != null) {
                    g2.setColor(this.gridColorRed);
                    g2.drawLine((int)prev2.getX() - 2, (int)prev2.getY() - 2, (int)point2.getX() - 2, (int)point2.getY() - 2);
                }
                if (i == 0 || i != second.size() - 1 || !geo.equals(second.get(0))) {
                    g2.setColor(Color.BLACK);
                    g2.drawString("" + (i + 1), (int)point2.getX() + 2, (int)point2.getY());
                }
                prev2 = point2;
                ++i;
            }
        }
        int lat = -90;
        while (lat < 90) {
            prev = null;
            int lon = -360;
            while (lon < 360) {
                point = map.getTileFactory().geoToPixel(new GeoPosition((double)lat, (double)lon), map.getZoom());
                if (prev != null) {
                    if (lat == 0) {
                        g2.setColor(this.gridColorRed);
                    } else {
                        g2.setColor(this.gridColor);
                    }
                    g2.drawLine((int)prev.getX(), (int)prev.getY(), (int)point.getX(), (int)point.getY());
                }
                prev = point;
                lon += 10;
            }
            lat += 5;
        }
        int lon = -360;
        while (lon < 360) {
            prev = null;
            int lat2 = -90;
            while (lat2 < 90) {
                point = map.getTileFactory().geoToPixel(new GeoPosition((double)lat2, (double)lon), map.getZoom());
                if (prev != null) {
                    if (lon == 0) {
                        g2.setColor(this.gridColorRed);
                    } else {
                        g2.setColor(this.gridColor);
                    }
                    g2.drawLine((int)prev.getX(), (int)prev.getY(), (int)point.getX(), (int)point.getY());
                }
                prev = point;
                lat2 += 5;
            }
            lon += 10;
        }
        g2.translate(viewportBounds.getX(), viewportBounds.getY());
        g2.dispose();
    }

    protected void doPaintInternal(Graphics2D g, JXMapViewer map, int width, int height) {
        Thread tt = null;
        ThreadChecker t = new ThreadChecker();
        Rectangle viewportBounds = map.getViewportBounds();
        try {
            g.translate(-viewportBounds.getX(), -viewportBounds.getY());
            if (this.WP.stream().map(Tuple::second).map(WaypointHolder::getWaypoints).map(List::size).reduce(0, (e, x) -> e + x) > 100000) {
                tt = new Thread(t);
                tt.start();
            }
            block3: for (Tuple<WaypointRenderer, WaypointHolder<Waypoint>> tuple : this.WP) {
                if (t.triggerDelay) {
                    break;
                }
                WaypointRenderer wr = (WaypointRenderer)tuple.first();
                if (wr instanceof IMultipointRenderer) {
                    ((IMultipointRenderer)wr).paintWaypoints(g, map, (WaypointHolder)tuple.second());
                    continue;
                }
                for (Waypoint w : ((WaypointHolder)tuple.second()).getWaypoints()) {
                    if (t.triggerDelay) continue block3;
                    wr.paintWaypoint(g, map, (Object)w);
                }
            }
        }
        finally {
            g.translate(viewportBounds.getX(), viewportBounds.getY());
            if (tt != null) {
                t.done = true;
                tt.interrupt();
            }
        }
    }

    private class ThreadChecker
    implements Runnable {
        private volatile boolean done;
        private volatile boolean triggerDelay = false;

        private ThreadChecker() {
        }

        @Override
        public void run() {
            try {
                try {
                    ThreadUtils.sleep((int)1000);
                    LocalDateTime dt = DateUtils.getTimeAtUTC();
                    while (!this.done) {
                        Thread.sleep(5000L);
                        if (dt.plusMinutes(1L).compareTo(DateUtils.getTimeAtUTC()) >= 0) continue;
                        this.triggerDelay = true;
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.triggerDelay = true;
                }
            }
            finally {
                this.triggerDelay = true;
            }
        }
    }
}

