/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.core.HintTextField;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.RegExFilter;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.GraphType;
import com.sigge.filerunner.view.results.graph.GraphView;
import com.sigge.filerunner.view.results.graph.IGraphHandler;
import com.sigge.filerunner.view.results.graph.geo.FromToWaypointRenderer2;
import com.sigge.filerunner.view.results.graph.geo.GeoDisplaySettings;
import com.sigge.filerunner.view.results.graph.geo.GeoManager;
import com.sigge.filerunner.view.results.graph.geo.GeoPainter;
import com.sigge.filerunner.view.results.graph.geo.GeoUtils;
import com.sigge.filerunner.view.results.graph.geo.Geoset2;
import com.sigge.filerunner.view.results.graph.geo.IdentityWaypointRenderer2;
import com.sigge.filerunner.view.results.graph.geo.LayerPainter;
import com.sigge.filerunner.view.results.graph.geo.OSMTileFactoryInfo2;
import com.sigge.filerunner.view.results.graph.geo.PlaySpeed;
import com.sigge.filerunner.view.results.graph.geo.RowDisplayType;
import com.sigge.filerunner.view.results.graph.geo.SelectionAdapter;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.FromToGeo;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ChangeListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.JXLabel;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.VirtualEarthTileFactoryInfo;
import org.jxmapviewer.input.PanKeyListener;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.Waypoint;

public class GeoGraphHandler2
implements IGraphHandler {
    private static final GeoManager MANAGER = new GeoManager();
    private GeoPainter sp;
    private GeoPosition lastcenter = null;
    public static final DefaultTileFactory TILE_DEFAULT = GeoGraphHandler2.createDefaultTileFactory();
    public static final DefaultTileFactory TILE_SAT = GeoGraphHandler2.createDefaultSatFactory();
    private static final String GRAPH_SHOW_FILTERED = "geograph.showFiltered";
    AtomicInteger aix = new AtomicInteger(1);
    private JXLabel positionLabel;

    @Override
    public void present(GraphView view, GraphType graphType, List<GraphResult> results, GraphResult resultSetChosen, boolean draw) {
        JPanel container = view.getSettingsPane();
        container.removeAll();
        view.getGraphpanel().removeAll();
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resultSetChosen.getResultSet() == null) {
            return;
        }
        JPanel jepee = new JPanel();
        CardLayout cardLayout = new CardLayout();
        jepee.setLayout(cardLayout);
        container.add(jepee);
        ArrayList<Geoset2> geosets = new ArrayList<Geoset2>();
        Optional<IGeoSetting> previous = MANAGER.loadPrevious(resultSetChosen, Optional.ofNullable(MANAGER.getLastType()));
        Geoset2 geoset = new Geoset2(jepee, results, resultSetChosen, previous, String.valueOf(this.aix.getAndIncrement()), MANAGER);
        geosets.add(geoset);
        JButton drawGraph = new JButton("Display graph", IconUtils.getSmallIcon("location.png"));
        JButton fullScreen = new JButton("Full screen", IconUtils.getSmallIcon("tv.png"));
        JButton addGraph = new JButton("Add graph");
        JButton removeGraph = new JButton("Remove graph");
        JButton previousGraph = new JButton("< Previous graph");
        ValueHolder<Integer> current = new ValueHolder<Integer>(0);
        JComboBox<Object> openGraph = new JComboBox<Object>();
        openGraph.setRenderer(new LabelledCellRenderer());
        JButton nextGraph = new JButton("> Next graph");
        Runnable syncButtons = () -> {
            nextGraph.setEnabled((Integer)current.getValue() < geosets.size() - 1);
            previousGraph.setEnabled((Integer)current.getValue() > 0);
            removeGraph.setEnabled(geosets.size() > 1);
            this.rebindGeoSets(geosets, openGraph, current);
        };
        syncButtons.run();
        openGraph.addActionListener(al -> {
            Integer selectedItem = (Integer)openGraph.getSelectedItem() - 1;
            cardLayout.show(jepee, "" + selectedItem);
            current.accept(selectedItem);
            syncButtons.run();
        });
        nextGraph.addActionListener(a -> {
            if ((Integer)current.getValue() + 1 >= geosets.size()) {
                return;
            }
            current.accept((Integer)current.getValue() + 1);
            String id = ((Geoset2)geosets.get((Integer)current.getValue())).getId();
            cardLayout.show(jepee, id);
            syncButtons.run();
        });
        previousGraph.addActionListener(a -> {
            if ((Integer)current.getValue() - 1 < 0) {
                return;
            }
            current.accept((Integer)current.getValue() - 1);
            String id = ((Geoset2)geosets.get((Integer)current.getValue())).getId();
            cardLayout.show(jepee, id);
            syncButtons.run();
        });
        JPanel jp = new JPanel(new FlowLayout(0));
        jp.add(addGraph);
        jp.add(removeGraph);
        jp.add(previousGraph);
        jp.add(openGraph);
        jp.add(nextGraph);
        jp.add(fullScreen);
        jp.add(drawGraph);
        container.add(jp);
        JPanel jpBrowser = new JPanel(new FlowLayout(0));
        JCheckBox filtered = new JCheckBox("Filtered");
        filtered.setSelected(ConfigHandler.getConfig().getBooleanConfigValue(GRAPH_SHOW_FILTERED, true));
        filtered.addActionListener(al -> ConfigHandler.getConfig().setConfigValue(GRAPH_SHOW_FILTERED, filtered.isSelected()));
        JLabel info = new JLabel("Display rows between");
        JButton back = new JButton("<-");
        HintTextField from = new HintTextField("Display rows from");
        from.setText("1");
        PlainDocument doc = (PlainDocument)from.getDocument();
        doc.setDocumentFilter(new RegExFilter("\\d+"));
        from.setPreferredSize(new Dimension(50, from.getPreferredSize().height));
        JLabel between = new JLabel("-");
        HintTextField to = new HintTextField("Display rows to");
        to.setText("" + resultSetChosen.getResultSet().getRowCount());
        PlainDocument doc2 = (PlainDocument)to.getDocument();
        doc2.setDocumentFilter(new RegExFilter("\\d+"));
        to.setPreferredSize(new Dimension(50, to.getPreferredSize().height));
        JButton forward = new JButton("->");
        JComboBox<RowDisplayType> rowDisplay = new JComboBox<RowDisplayType>();
        Binder.bindToCombo(rowDisplay, Arrays.asList(RowDisplayType.values()));
        rowDisplay.setRenderer(new LabelledCellRenderer());
        jpBrowser.add(filtered);
        jpBrowser.add(info);
        jpBrowser.add(back);
        jpBrowser.add(from);
        jpBrowser.add(between);
        jpBrowser.add(to);
        jpBrowser.add(forward);
        jpBrowser.add(rowDisplay);
        JLabel trail = new JLabel("Trail X rows");
        JTextField lagNumber = new JTextField("0");
        lagNumber.setPreferredSize(new Dimension(50, lagNumber.getPreferredSize().height));
        PlainDocument doc3 = (PlainDocument)lagNumber.getDocument();
        doc3.setDocumentFilter(new RegExFilter("\\d+"));
        final AtomicBoolean suspend = new AtomicBoolean(false);
        AtomicBoolean playing = new AtomicBoolean(false);
        JCheckBox focusOnPosition = new JCheckBox("Keep focus");
        focusOnPosition.setSelected(true);
        JCheckBox deleteDups = new JCheckBox("Remove dup geos");
        deleteDups.setSelected(true);
        JButton play = new JButton("Play");
        JComboBox<PlaySpeed> playSpeed = new JComboBox<PlaySpeed>(PlaySpeed.values());
        playSpeed.setSelectedItem(MANAGER.getLastPlaySpeed());
        playSpeed.setRenderer(new LabelledCellRenderer());
        playSpeed.setMaximumRowCount(16);
        Player playa = new Player(playing, play, from, to, forward, back, resultSetChosen, lagNumber, filtered, suspend, playSpeed, rowDisplay, focusOnPosition, deleteDups);
        back.addActionListener(e -> {
            Optional<GeoDisplaySettings> gs = this.getSettings(playa, false, false);
            if (!gs.isPresent()) {
                return;
            }
            GeoDisplaySettings ds = gs.get();
            int newTo = ds.getFrom() - 1;
            int newFrom = ds.getFrom() - (ds.getTo() - ds.getFrom()) - 1;
            if (newTo <= 0) {
                return;
            }
            suspend.set(true);
            from.setText("" + newFrom);
            suspend.set(false);
            to.setText("" + newTo);
        });
        forward.addActionListener(e -> this.advanceForward(resultSetChosen, playa, suspend));
        play.addActionListener(playa);
        jpBrowser.add(play);
        jpBrowser.add(playSpeed);
        jpBrowser.add(trail);
        jpBrowser.add(lagNumber);
        jpBrowser.add(focusOnPosition);
        jpBrowser.add(deleteDups);
        this.positionLabel = new JXLabel();
        jpBrowser.add((Component)this.positionLabel);
        container.add(jpBrowser);
        fullScreen.addActionListener(l -> {
            final JMemoryFrame jf = new JMemoryFrame("Map", "Map");
            JPanel gv = new JPanel();
            gv.setLayout(new BorderLayout());
            if (!jf.isSizeSetFromSettings()) {
                jf.setExtendedState(6);
            }
            Optional<GeoDisplaySettings> displaySettings = this.getSettings(playa, true, false);
            final ValueHolder vh = new ValueHolder();
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    vh.getOptionalValue().ifPresent(AbstractTileFactory::dispose);
                }
            });
            jf.getContentPane().add(gv);
            if (displaySettings.isPresent()) {
                SwingUtilities.invokeLater(() -> {
                    this.drawGeoPoints(gv, resultSetChosen, geosets, (GeoDisplaySettings)displaySettings.get(), false, false, (Consumer<DefaultTileFactory>)((Object)vh));
                    gv.setSize(jf.getSize());
                });
            }
            jf.setVisible(true);
        });
        ((Component)container).revalidate();
        final ChangeListener cl = () -> this.getSettings(playa, true, playa.playing.get()).ifPresent(e -> this.graph(view, resultSetChosen, geosets, (GeoDisplaySettings)e, null));
        ChangeListener changeManually = () -> {
            view.getJSplitPane1().setDividerLocation(-1);
            cl.changed();
        };
        from.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                if (!suspend.get()) {
                    cl.changed();
                }
            }
        });
        to.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                if (!suspend.get()) {
                    cl.changed();
                }
            }
        });
        rowDisplay.addActionListener(l -> cl.changed());
        doc3.addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
            }
        });
        geoset.addModelListener(changeManually);
        filtered.addActionListener(e -> cl.changed());
        drawGraph.addActionListener(al -> this.getSettings(playa, true, false).ifPresent(x -> SwingUtilities.invokeLater(() -> this.drawGeoPoints(view.getGraphpanel(), resultSetChosen, geosets, (GeoDisplaySettings)x, true, true, null))));
        addGraph.addActionListener(l -> {
            IGeoSetting geo = ((Geoset2)geosets.get(geosets.size() - 1)).getSettings().copy();
            Geoset2 e = new Geoset2(jepee, results, resultSetChosen, Optional.ofNullable(geo), String.valueOf(this.aix.getAndIncrement()), MANAGER);
            geosets.add(e);
            current.accept(geosets.size() - 1);
            cardLayout.show(jepee, e.getId());
            syncButtons.run();
            e.addModelListener(changeManually);
            view.getJSplitPane1().setDividerLocation(-1);
            view.revalidate();
            view.repaint();
            changeManually.changed();
        });
        removeGraph.addActionListener(l -> {
            if (geosets.size() > 1) {
                Geoset2 gs = (Geoset2)geosets.remove((Integer)current.getValue());
                gs.removeSet();
                if (((Integer)current.getValue()).intValue() == geosets.size()) {
                    current.accept((Integer)current.getValue() - 1);
                    cardLayout.show(jepee, ((Geoset2)geosets.get((Integer)current.getValue())).getId());
                } else {
                    current.accept((Integer)current.getValue());
                    cardLayout.show(jepee, ((Geoset2)geosets.get((Integer)current.getValue())).getId());
                }
                view.getJSplitPane1().setDividerLocation(-1);
                view.revalidate();
                view.repaint();
                syncButtons.run();
            }
            changeManually.changed();
        });
        if (draw) {
            this.getSettings(playa, true, false).ifPresent(e -> this.graph(view, resultSetChosen, (List<Geoset2>)geosets, (GeoDisplaySettings)e, null));
        }
    }

    private static DefaultTileFactory createDefaultSatFactory() {
        VirtualEarthTileFactoryInfo info = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID);
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        tileFactory.setThreadPoolSize(8);
        return tileFactory;
    }

    private static DefaultTileFactory createDefaultTileFactory() {
        OSMTileFactoryInfo2 info = new OSMTileFactoryInfo2();
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        tileFactory.setThreadPoolSize(8);
        return tileFactory;
    }

    private void rebindGeoSets(List<Geoset2> geosets, JComboBox<Integer> openGraph, ValueHolder<Integer> current) {
        Binder.bindToCombo(openGraph, IntStream.range(1, geosets.size() + 1).mapToObj(u -> u).collect(Collectors.toList()), (boolean)true);
        openGraph.setSelectedIndex(current.getValue());
    }

    private int getCountFromResultSet(IResultSetTable table, boolean filtered) {
        if (!filtered) {
            return table.getRowCount();
        }
        ResultSetTableModel rstm = (ResultSetTableModel)table;
        return rstm.getSorter().getViewRowCount();
    }

    private boolean advanceForward(GraphResult resultSetChosen, Player player, AtomicBoolean suspend) {
        Optional<GeoDisplaySettings> gs = this.getSettings(player, true, true);
        if (!gs.isPresent()) {
            return false;
        }
        GeoDisplaySettings ds = gs.get();
        int newFrom = ds.getTo() + 1;
        int newTo = ds.getTo() + ds.getTo() - ds.getFrom() + 1;
        if (newFrom > this.getCountFromResultSet(resultSetChosen.getResultSet(), ds.isFiltered())) {
            return false;
        }
        suspend.set(true);
        player.from.setText("" + newFrom);
        suspend.set(false);
        player.to.setText("" + newTo);
        return true;
    }

    private Optional<GeoDisplaySettings> getSettings(Player player, boolean forward, boolean playMode) {
        if (player.from.getText().length() > 0 && player.to.getText().length() > 0) {
            int lag = 0;
            try {
                lag = Integer.valueOf(player.lagNumber.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Optional.of(new GeoDisplaySettings(Integer.valueOf(player.from.getText()), Integer.valueOf(player.to.getText()), lag, forward, playMode, player.filtered.isSelected(), (RowDisplayType)player.displayType.getSelectedItem(), player.focusOnPosition.isSelected(), player.deleteDups.isSelected()));
        }
        return Optional.empty();
    }

    private void graph(GraphView view, GraphResult resultSetChosen, List<Geoset2> geosets, GeoDisplaySettings gs, Consumer<DefaultTileFactory> tileDisposer) {
        SwingUtilities.invokeLater(() -> SwingUtilities.invokeLater(() -> this.drawGeoPoints(view.getGraphpanel(), resultSetChosen, geosets, gs, true, false, tileDisposer)));
    }

    public static boolean isNumber(IResultSetTable resultSet, int col1) {
        if (col1 == -1) {
            return false;
        }
        return GraphHandler.VALUE_TYPE.getFromType(resultSet.getFieldType(col1)) == GraphHandler.VALUE_TYPE.NUMBER;
    }

    public static boolean isGeo(IResultSetTable resultSet, int col1) {
        if (col1 == -1) {
            return false;
        }
        return GraphHandler.VALUE_TYPE.getFromType(resultSet.getFieldType(col1)) == GraphHandler.VALUE_TYPE.GEO;
    }

    void drawGeoPoints(JPanel view, GraphResult resultSetChosen, List<? extends Geoset2> geosets, GeoDisplaySettings displaySettings, boolean inFrame, boolean force, Consumer<DefaultTileFactory> disposer) {
        for (Geoset2 geoset2 : geosets) {
            if (geoset2.getSettings().isValid()) continue;
            this.displayError(view, "Either latitude or longitude column is not a number type or latitude is same as longitude or heatmap value isn't defined correctly");
            this.sp = null;
            return;
        }
        if (!(force || !inFrame || resultSetChosen.getResultSet().getRowCount() < 100000 || geosets.stream().anyMatch(gs -> gs.getType().filter(p -> p.equals(GeoType.HEATMAP)).isPresent()) || displaySettings.getTo() - displaySettings.getFrom() + displaySettings.getLagNumber() < 100000 || displaySettings.isPlayMode() || this.okToGraph(resultSetChosen, view))) {
            return;
        }
        if (!inFrame || this.sp == null) {
            JXMapKit jXMapKit = new JXMapKit();
            jXMapKit.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
            view.removeAll();
            if (view.getLayout() instanceof BorderLayout) {
                view.add((Component)jXMapKit, "Center");
            } else {
                view.add((Component)jXMapKit);
            }
            jXMapKit.setSize(600, 400);
            jXMapKit.setTileFactory((TileFactory)TILE_DEFAULT);
            if (disposer != null) {
                disposer.accept(TILE_DEFAULT);
            }
            SelectionAdapter sa = new SelectionAdapter(jXMapKit.getMainMap(), a -> {
                if (this.positionLabel != null) {
                    this.positionLabel.setText("Position: " + TILE_DEFAULT.pixelToGeo(a, mapViewer.getMainMap().getZoom()));
                }
            });
            GeoPainter sp = new GeoPainter(sa);
            Optional<Waypoint> some2 = this.getGeos(sp, geosets, displaySettings);
            jXMapKit.getMainMap().addMouseListener((MouseListener)sa);
            jXMapKit.getMainMap().addMouseMotionListener((MouseMotionListener)sa);
            some2.ifPresent(e -> GeoUtils.getPositionFromWaypoint(e).ifPresent(p -> {
                mapViewer.setCenterPosition(p);
                HashSet<GeoPosition> geoss = new HashSet<GeoPosition>();
                geoss.add((GeoPosition)p);
            }));
            if (!some2.isPresent()) {
                GeoPosition geoPosition = new GeoPosition(0.0, 0.0);
                jXMapKit.setCenterPosition(geoPosition);
                HashSet<GeoPosition> geoss = new HashSet<GeoPosition>();
                geoss.add(geoPosition);
            }
            jXMapKit.getMainMap().addKeyListener((KeyListener)new PanKeyListener(jXMapKit.getMainMap()));
            jXMapKit.getMainMap().setOverlayPainter((Painter)sp);
            if (inFrame) {
                jXMapKit.setZoom(18);
            } else {
                jXMapKit.setZoom(17);
                SwingUtilities.invokeLater(() -> mapViewer.getMainMap().setCenter(mapViewer.getMainMap().convertGeoPositionToPoint(new GeoPosition(0.0, 0.0))));
            }
            if (inFrame && this.sp == null) {
                this.sp = sp;
            }
        } else {
            this.sp.clear();
            this.getGeos(this.sp, geosets, displaySettings).ifPresent(some -> GeoUtils.getPositionFromWaypoint(some).ifPresent(cc -> {
                if (!cc.equals((Object)this.lastcenter)) {
                    this.sp.setCenter((Waypoint)new DefaultWaypoint(cc));
                    this.lastcenter = cc;
                }
            }));
        }
        view.revalidate();
        view.repaint();
        if (!displaySettings.isPlayMode() && inFrame) {
            for (Geoset2 geoset2 : geosets) {
                MANAGER.store(geoset2.getSettings());
            }
        }
    }

    private Optional<Waypoint> getGeos(GeoPainter sp, List<? extends Geoset2> geosets, GeoDisplaySettings displaySettings) {
        Optional<Waypoint> some = Optional.empty();
        for (Geoset2 geoset2 : geosets) {
            Optional opt;
            geoset2.getMathBuilder().reset();
            GeoType visualize = geoset2.getSettings().getType();
            WaypointHolder<Waypoint> handler = visualize.getHandler().generateWayPoints(geoset2.getSettings(), displaySettings);
            if (!some.isPresent() && visualize != GeoType.HEATMAP && !some.isPresent() && (opt = handler.getWaypoints().stream().findFirst()).isPresent()) {
                some = Optional.of((Waypoint)opt.get());
            }
            switch (visualize) {
                case WAYPOINT: {
                    IdentityWaypointRenderer2 wr = new IdentityWaypointRenderer2(geoset2.getAsSingleGeo().getPointIcon());
                    sp.addWaypoints(wr, handler);
                    break;
                }
                case HEATMAP: {
                    LayerPainter lp = new LayerPainter(geoset2.getMathBuilder());
                    sp.addWaypoints(lp, handler);
                    break;
                }
                case TRIP: {
                    FromToGeo gg = geoset2.getAsTripGeo();
                    FromToWaypointRenderer2 from = new FromToWaypointRenderer2(gg.getPointIcon(), gg.getPointIconTo());
                    sp.addWaypoints(from, handler);
                }
            }
        }
        return some;
    }

    @Override
    public void close() throws IOException {
        this.positionLabel = null;
        if (this.sp != null) {
            this.sp.clear();
            this.sp = null;
        }
        this.aix.set(0);
    }

    private final class Player
    implements ActionListener {
        ScheduledExecutorService sex = Executors.newSingleThreadScheduledExecutor();
        private ScheduledFuture<Void> sf = null;
        private final AtomicBoolean playing;
        private final JButton play;
        private final JTextField from;
        private final JTextField to;
        private final JButton forward;
        private final JButton back;
        private final JTextField lagNumber;
        private final AtomicBoolean suspend;
        private final GraphResult resultSetChosen;
        private final JComboBox<PlaySpeed> playSpeed;
        private final JCheckBox filtered;
        private final JComboBox<RowDisplayType> displayType;
        private JCheckBox focusOnPosition;
        private JCheckBox deleteDups;

        Player(AtomicBoolean playing, JButton play, JTextField from, JTextField to, JButton forward, JButton back, GraphResult resultSetChosen, JTextField lagNumber, JCheckBox filtered, AtomicBoolean suspend, JComboBox<PlaySpeed> playSpeed, JComboBox<RowDisplayType> displayType, JCheckBox focusOnPosition, JCheckBox deleteDups) {
            this.playing = playing;
            this.play = play;
            this.from = from;
            this.to = to;
            this.forward = forward;
            this.back = back;
            this.resultSetChosen = resultSetChosen;
            this.lagNumber = lagNumber;
            this.filtered = filtered;
            this.suspend = suspend;
            this.playSpeed = playSpeed;
            this.displayType = displayType;
            this.focusOnPosition = focusOnPosition;
            this.deleteDups = deleteDups;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.playing.get()) {
                this.reset();
            } else {
                this.playing.set(true);
                this.play.setText("Stop");
                this.from.setEnabled(false);
                this.to.setEnabled(false);
                this.forward.setEnabled(false);
                this.back.setEnabled(false);
                MANAGER.setLastPlaySpeed(this.playSpeed.getItemAt(this.playSpeed.getSelectedIndex()));
                this.start();
            }
        }

        private void reset() {
            this.playing.set(false);
            this.play.setText("Play");
            if (this.sf != null) {
                this.sf.cancel(true);
                this.sf = null;
                this.from.setEnabled(true);
                this.to.setEnabled(true);
                this.forward.setEnabled(true);
                this.back.setEnabled(true);
            }
        }

        private void start() {
            if (this.sf != null && this.sf.isCancelled()) {
                return;
            }
            this.sf = this.sex.schedule(() -> {
                boolean result = GeoGraphHandler2.this.advanceForward(this.resultSetChosen, this, this.suspend);
                if (!result) {
                    this.reset();
                } else {
                    this.start();
                }
                return null;
            }, (long)((int)(this.playSpeed.getItemAt(this.playSpeed.getSelectedIndex()).getSpeed() * 1000.0)), TimeUnit.MILLISECONDS);
        }
    }
}

