/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.SeriesTranslator;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.AbstractXYDataset;

public class ResultSetTableXYWrapper
extends AbstractXYDataset {
    private final IResultSetTable rstm;
    private final int xCol;
    private final int yCol;
    final GraphHandler.VALUE_TYPE xType;
    private final GraphHandler.VALUE_TYPE yType;
    public static final String NULL_COLUMN_ITEM = "-";
    private final Map<Integer, SeriesTranslator> MAPPER;
    private final Map<Object, Integer> SERIES_MAPPER;
    private final Map<Integer, Object> SERIES_MAPPER2;

    public ResultSetTableXYWrapper(IResultSetTable rstm, int xCol, int yCol) {
        this.rstm = rstm;
        this.xCol = xCol;
        this.yCol = yCol;
        this.xType = GraphHandler.VALUE_TYPE.getFromType(rstm.getFieldType(xCol));
        this.yType = GraphHandler.VALUE_TYPE.getFromType(rstm.getFieldType(yCol));
        this.MAPPER = null;
        this.SERIES_MAPPER = null;
        this.SERIES_MAPPER2 = null;
    }

    public ResultSetTableXYWrapper(IResultSetTable rstm, int xCol, int yCol, int seriesIdentifier) {
        this.rstm = rstm;
        this.xCol = xCol;
        this.yCol = yCol;
        this.xType = GraphHandler.VALUE_TYPE.getFromType(rstm.getFieldType(xCol));
        this.yType = GraphHandler.VALUE_TYPE.getFromType(rstm.getFieldType(yCol));
        AtomicInteger series = new AtomicInteger(0);
        this.MAPPER = new HashMap<Integer, SeriesTranslator>();
        this.SERIES_MAPPER = new HashMap<Object, Integer>();
        this.SERIES_MAPPER2 = new HashMap<Integer, Object>();
        int i = 0;
        while (i < rstm.getRowCount()) {
            Object o = rstm.getValueAt(i, seriesIdentifier);
            Integer seriesId = this.SERIES_MAPPER.computeIfAbsent(o, x -> series.getAndIncrement());
            this.SERIES_MAPPER2.computeIfAbsent(seriesId, x -> o);
            this.MAPPER.computeIfAbsent(seriesId, s -> new SeriesTranslator()).addRow(i);
            ++i;
        }
    }

    public static CategoryDataset createDataset(IResultSetTable rstm, int xCol, int yCol, int seriesIdentifier) {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        int i = 0;
        while (i < rstm.getRowCount()) {
            Comparable valueAt = (Comparable)rstm.getValueAt(i, seriesIdentifier);
            if (xCol == -1) {
                ds.addValue((Number)rstm.getValueAt(i, yCol), (Comparable)Integer.valueOf(0), (Comparable)(valueAt == null ? NULL_COLUMN_ITEM : valueAt));
            } else {
                Comparable valueAt2 = (Comparable)rstm.getValueAt(i, xCol);
                ds.addValue((Number)rstm.getValueAt(i, yCol), (Comparable)(valueAt == null ? NULL_COLUMN_ITEM : valueAt), (Comparable)(valueAt2 == null ? NULL_COLUMN_ITEM : valueAt2));
            }
            ++i;
        }
        return ds;
    }

    public int getItemCount(int series) {
        if (this.MAPPER == null) {
            return this.rstm.getRowCount();
        }
        return this.MAPPER.get(this.SERIES_MAPPER.get(this.SERIES_MAPPER2.get(series))).getRowCount();
    }

    public Number getX(int series, int item) {
        Object realValue = null;
        realValue = this.MAPPER == null ? this.rstm.getValueAt(item, this.xCol) : this.rstm.getValueAt(this.MAPPER.get(this.SERIES_MAPPER.get(this.SERIES_MAPPER2.get(series))).getRow(item), this.xCol);
        if (realValue instanceof Number) {
            return (Number)realValue;
        }
        if (realValue instanceof Timestamp) {
            return ((Timestamp)realValue).getTime();
        }
        return null;
    }

    public Number getY(int series, int item) {
        Object realValue = null;
        realValue = this.MAPPER == null ? this.rstm.getValueAt(item, this.yCol) : this.rstm.getValueAt(this.MAPPER.get(this.SERIES_MAPPER.get(this.SERIES_MAPPER2.get(series))).getRow(item), this.yCol);
        if (realValue instanceof Number) {
            return (Number)realValue;
        }
        if (realValue instanceof Timestamp) {
            return ((Timestamp)realValue).getTime();
        }
        return null;
    }

    public int getSeriesCount() {
        if (this.MAPPER == null) {
            return 1;
        }
        return this.MAPPER.size();
    }

    public Comparable getSeriesKey(int series) {
        if (this.MAPPER == null) {
            return Integer.valueOf(series);
        }
        Object o = this.SERIES_MAPPER2.get(series);
        if (o instanceof Comparable) {
            return (Comparable)o;
        }
        return Integer.valueOf(series);
    }

    public GraphHandler.VALUE_TYPE getxType() {
        return this.xType;
    }

    public GraphHandler.VALUE_TYPE getyType() {
        return this.yType;
    }
}

