/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ResultColumnMapper {
    private final Map<Integer, Tuple<String, String>> indexToNameMapping = new HashMap<Integer, Tuple<String, String>>();
    private final Map<String, Set<Integer>> nameToIndicesMapping = new HashMap<String, Set<Integer>>();
    private final Map<Integer, GraphHandler.VALUE_TYPE> indexToTypeMapping = new HashMap<Integer, GraphHandler.VALUE_TYPE>();
    private final boolean caseSensitive;
    private final GraphResult result;

    public ResultColumnMapper(GraphResult gr, boolean caseSensitive) {
        this.result = gr;
        IResultSetTable result = gr.getResultSet();
        this.caseSensitive = caseSensitive;
        int i = 0;
        while (i < result.getColumnCount()) {
            String name = caseSensitive ? result.getColumnName(i) : result.getColumnName(i).toLowerCase();
            this.indexToNameMapping.put(i, (Tuple<String, String>)Tuple.of((Object)name, (Object)result.getColumnName(i)));
            Set set = this.nameToIndicesMapping.computeIfAbsent(name, s -> new HashSet());
            set.add(i);
            this.indexToTypeMapping.put(i, GraphHandler.VALUE_TYPE.getFromType(result.getFieldType(i)));
            ++i;
        }
    }

    public Optional<Tuple<Integer, String>> resolveColumn(String name, int index, GraphHandler.VALUE_TYPE ... types) {
        Set<Integer> potentials = this.nameToIndicesMapping.get(this.caseSensitive ? name : name.toLowerCase());
        if (potentials == null) {
            return Optional.empty();
        }
        int diff = Integer.MAX_VALUE;
        int bestMatch = -1;
        for (Integer potential : potentials) {
            int abs;
            if (types.length > 0 && !ListUtils.in((Object)((Object)this.indexToTypeMapping.get(potential)), (Object[])types) || (abs = Math.abs(potential - index)) >= diff) continue;
            if (abs == 0) {
                return Optional.of(Tuple.of((Object)potential, (Object)((String)this.indexToNameMapping.get(potential).second())));
            }
            bestMatch = potential;
            diff = abs;
        }
        if (bestMatch >= 0) {
            return Optional.of(Tuple.of((Object)bestMatch, (Object)((String)this.indexToNameMapping.get(bestMatch).second())));
        }
        return Optional.empty();
    }

    public GraphResult getResult() {
        return this.result;
    }
}

