/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.export;

import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.core.FileTransferable;
import com.sigge.filerunner.core.ProcessUtils;
import com.sigge.filerunner.view.core.ButtonColumn;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.results.ResultSetTableModelRenderer;
import com.sigge.filerunner.view.results.export.FileExportTableModel;
import com.sigge.filerunner.view.results.export.FileExportView;
import com.sigge.filerunner.view.results.export.FileResult;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FileExportHandler
implements Closeable {
    private final FileExportView view = new FileExportView();
    private final List<FileResult> results = new ArrayList<FileResult>();
    private final FileExportTableModel dataModel = new FileExportTableModel(this.results);

    public FileExportHandler() {
        VTable fileTable = this.view.getFileTable();
        fileTable.setAutoResizeMode(4);
        fileTable.setModel((TableModel)((Object)this.dataModel));
        TableColumnModel model = fileTable.getColumnModel();
        model.getColumn(0).setPreferredWidth(100);
        model.getColumn(1).setPreferredWidth(100);
        model.getColumn(2).setCellRenderer(new ResultSetTableModelRenderer());
        model.getColumn(2).setPreferredWidth(400);
        model.getColumn(3).setPreferredWidth(400);
        model.getColumn(4).setPreferredWidth(100);
        model.getColumn(5).setPreferredWidth(100);
        model.getColumn(6).setPreferredWidth(100);
        model.getColumn(7).setPreferredWidth(100);
        new ButtonColumn((JTable)((Object)fileTable), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                ProcessUtils.browseToFile(((FileResult)FileExportHandler.this.dataModel.getValueAt(modelRow)).getFile());
            }
        }, 4);
        new ButtonColumn((JTable)((Object)fileTable), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                try {
                    Desktop.getDesktop().open(((FileResult)FileExportHandler.this.dataModel.getValueAt(modelRow)).getFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 5);
        new ButtonColumn((JTable)((Object)fileTable), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                String path = ((FileResult)FileExportHandler.this.dataModel.getValueAt(modelRow)).getFile().getAbsolutePath();
                ClipboardUtils.setStringDataToClipboard(path);
            }
        }, 6);
        new ButtonColumn((JTable)((Object)fileTable), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                FileTransferable ft = new FileTransferable(Arrays.asList(((FileResult)FileExportHandler.this.dataModel.getValueAt(modelRow)).getFile()));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ft, ft);
            }
        }, 7);
    }

    public void addResult(FileResult fr) {
        this.dataModel.addRow(fr);
    }

    public FileExportView getView() {
        return this.view;
    }

    @Override
    public void close() throws IOException {
    }
}

