/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.core.DateUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;

public class TimeStampWrapperHandler {
    public static Object get(ResultSet rs, int column) throws SQLException {
        Timestamp ts;
        block6: {
            try {
                ts = rs.getTimestamp(column);
                if (ts != null) break block6;
                return null;
            }
            catch (SQLException e) {
                try {
                    LocalDateTime lds = rs.getObject(column, LocalDateTime.class);
                    if (lds == null) {
                        return rs.getString(column);
                    }
                    return Timestamp.valueOf(lds).getTime();
                }
                catch (Exception exception) {
                    return rs.getString(column);
                }
            }
        }
        return ts.getTime();
    }

    public static Timestamp getFromObject(Object o) {
        if (o instanceof Long) {
            return new Timestamp((Long)o);
        }
        return null;
    }

    public static boolean containsTimeInfo(Object o) {
        if (o instanceof Long) {
            return TimeStampWrapperHandler.containsTimeInfo(new Timestamp((Long)o));
        }
        return false;
    }

    public static boolean containsTimeInfo(Timestamp ts) {
        if (ts == null) {
            return false;
        }
        return ts.getNanos() == 0 && ts.getSeconds() == 0 && ts.getMinutes() == 0 && ts.getHours() == 0;
    }

    public static String getValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return TimeStampWrapperHandler.getTimestampValue(new Timestamp((Long)o), false);
        }
        if (o instanceof Timestamp) {
            return TimeStampWrapperHandler.getTimestampValue((Timestamp)o, false);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static String getTimestampValue(Timestamp ts, boolean abbr) {
        if (ts.getNanos() == 0 && ts.getSeconds() == 0 && ts.getMinutes() == 0 && ts.getHours() == 0) {
            String format = DateUtils.FORMAT_YYYYMMDD.format(ts.getTime());
            return format;
        }
        if (abbr) {
            return DateUtils.FORMAT_WITH_TIME_COMPACT.format(ts);
        }
        return DateUtils.FORMAT_WITH_TIME_AND_MS.format(ts);
    }

    public static int compareTo(Object o, Object o2) {
        if (o instanceof Long && o2 instanceof Long) {
            return ((Long)o).compareTo((Long)o2);
        }
        if (o instanceof Timestamp && o2 instanceof Timestamp) {
            return ((Timestamp)o).compareTo((Timestamp)o2);
        }
        return TimeStampWrapperHandler.getValue(o).compareTo(TimeStampWrapperHandler.getValue(o2));
    }
}

