/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.results.IResultSetConverter;
import com.sigge.filerunner.view.results.IResultSetTable;
import dnl.utils.text.table.TextTable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextResultSetConverter
implements IResultSetConverter<StringBuilder> {
    private static Logger LOGGER = LoggerFactory.getLogger(TextResultSetConverter.class);

    @Override
    public StringBuilder convert(IResultSetTable rstm) {
        TextTable tt = new TextTable(rstm.getTableModel(), true);
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String utf8 = StandardCharsets.UTF_8.name();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (PrintStream ps = new PrintStream((OutputStream)baos, true, utf8);){
                tt.printTable(ps, 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while parsing data", (Throwable)e);
        }
        try {
            return new StringBuilder(baos.toString(utf8));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error occured while converting to utf8", (Throwable)e);
            return sb;
        }
    }
}

