/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.project;

import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.view.project.IProjectFilter;
import com.sigge.filerunner.view.project.ProjectTreeHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class DefaultProjectFilter
implements IProjectFilter {
    public final List<Function<File, Boolean>> fileFilterPositive = this.createPositiveFileFilter();
    public final List<Function<File, Boolean>> dirFilterPositive = this.createPositiveDirFilter();
    public final List<Function<File, Boolean>> fileFilterNegative = this.createNegativeFileFilter();
    public final List<Function<File, Boolean>> dirFilterNegative = this.createNegativeDirFilter();

    @Override
    public boolean filter(ProjectTreeHandler.Item item) {
        if (item.fileItem != null) {
            File f = item.fileItem;
            if (f.isFile()) {
                if (this.applyFilter(f, this.fileFilterPositive, false)) {
                    return true;
                }
                if (this.fileFilterPositive.size() > 0) {
                    return false;
                }
                return !this.applyFilter(f, this.fileFilterNegative, false);
            }
            if (this.applyFilter(f, this.dirFilterPositive, false)) {
                return true;
            }
            if (this.dirFilterPositive.size() > 0) {
                return false;
            }
            return !this.applyFilter(f, this.dirFilterNegative, false);
        }
        return true;
    }

    public boolean applyFilter(File f, List<Function<File, Boolean>> filters, boolean ifEmpty) {
        if (filters.size() == 0) {
            return ifEmpty;
        }
        for (Function<File, Boolean> s : filters) {
            if (!s.apply(f).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected List<Function<File, Boolean>> createNegativeDirFilter() {
        return Arrays.asList(new Function<File, Boolean>(){

            @Override
            public Boolean apply(File t) {
                return t.getName().startsWith(".");
            }
        }, this.fileMatchesName("build", "deploy", "gradle", "lib", "target", "bin", "obj"));
    }

    protected List<Function<File, Boolean>> createNegativeFileFilter() {
        return Collections.EMPTY_LIST;
    }

    protected List<Function<File, Boolean>> createPositiveDirFilter() {
        return Collections.EMPTY_LIST;
    }

    protected List<Function<File, Boolean>> createPositiveFileFilter() {
        return Arrays.asList(this.fileMatchesExtensions("sql", "java"));
    }

    Function<File, Boolean> fileMatchesName(String ... names) {
        return f -> FileUtils.hasName(f, names);
    }

    Function<File, Boolean> fileMatchesExtensions(String ... extensions) {
        return f -> FileUtils.hasExtension(f, extensions);
    }
}

