/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuItemBuilder<E extends JMenuItem> {
    private final E item;
    private String caption;
    private String configSetting;
    private KeyStroke keyStroke;
    private ActionListener listener;
    private boolean reverseMode = false;
    private Boolean defaultValue;
    private Icon icon;
    private Supplier<Boolean> newValue;

    public MenuItemBuilder(Supplier<E> itemSupplier) {
        this.item = (JMenuItem)itemSupplier.get();
    }

    public MenuItemBuilder caption(String caption) {
        this.caption = caption;
        return this;
    }

    public MenuItemBuilder configSetting(String configSetting, boolean defaultValue, boolean reverseMode) {
        this.configSetting = configSetting;
        this.defaultValue = defaultValue;
        this.reverseMode = reverseMode;
        return this;
    }

    public MenuItemBuilder key(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        return this;
    }

    public MenuItemBuilder action(ActionListener listener) {
        this.listener = listener;
        return this;
    }

    public MenuItemBuilder icon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public MenuItemBuilder defaultValue(boolean defaultValue, Supplier<Boolean> newValue) {
        this.defaultValue = defaultValue;
        this.newValue = newValue;
        return this;
    }

    public MenuItemBuilder defaultValue(Supplier<Boolean> newValue) {
        this.defaultValue = newValue.get();
        this.newValue = newValue;
        return this;
    }

    public E build() {
        if (this.configSetting == null && this.listener == null) {
            throw new IllegalStateException("Config and action listener cannot both be null, nothing to do with the menu");
        }
        AbstractAction ab = new AbstractAction(this.caption, this.icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MenuItemBuilder.this.listener != null) {
                    MenuItemBuilder.this.listener.actionPerformed(e);
                    if (MenuItemBuilder.this.newValue != null) {
                        MenuItemBuilder.this.item.setSelected((Boolean)MenuItemBuilder.this.newValue.get());
                    }
                } else {
                    JMenuItem jm = (JMenuItem)e.getSource();
                    Config c = ConfigHandler.getConfig();
                    c.setConfigValue(MenuItemBuilder.this.configSetting, MenuItemBuilder.this.reverseMode ? !jm.isSelected() : jm.isSelected());
                    ConfigHandler.saveInBackground();
                }
            }
        };
        if (this.configSetting != null) {
            Boolean booleanConfigValue = ConfigHandler.getConfig().getBooleanConfigValue(this.configSetting, null);
            booleanConfigValue = booleanConfigValue == null ? this.defaultValue : Boolean.valueOf(this.reverseMode ? !booleanConfigValue.booleanValue() : booleanConfigValue);
            ((AbstractButton)this.item).setSelected(booleanConfigValue);
        } else if (this.defaultValue != null) {
            ((AbstractButton)this.item).setSelected(this.defaultValue);
        }
        if (this.keyStroke != null) {
            ab.putValue("AcceleratorKey", this.keyStroke);
        }
        ((AbstractButton)this.item).setAction(ab);
        return this.item;
    }
}

