/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.IMenuComponent;
import com.sigge.filerunner.view.menu.IMenuItem;
import com.sigge.filerunner.view.menu.IMenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Menu
implements IMenu {
    private final List<Tuple<Integer, IMenuItem>> items = new ArrayList<Tuple<Integer, IMenuItem>>();
    private final List<Tuple<Integer, IMenuItemGroup>> itemGroups = new ArrayList<Tuple<Integer, IMenuItemGroup>>();
    private final List<IMenuComponent> componentList = new ArrayList<IMenuComponent>();
    private final MenuType type;
    private final List<IMenu.ChangeListener> listeners = new ArrayList<IMenu.ChangeListener>();

    public Menu(MenuType type) {
        this.type = type;
    }

    @Override
    public void addItem(IMenuItem item, int sortGroup) {
        this.items.add((Tuple<Integer, IMenuItem>)Tuple.of((Object)sortGroup, (Object)item));
        this.componentList.add(item);
    }

    @Override
    public void addItemGroup(IMenuItemGroup itemGroup, int sortGroup) {
        this.itemGroups.add((Tuple<Integer, IMenuItemGroup>)Tuple.of((Object)sortGroup, (Object)itemGroup));
    }

    @Override
    public void replaceItem(IMenuItem oldItem, IMenuItem newItem) {
        int i = this.items.size() - 1;
        while (i <= 0) {
            Tuple<Integer, IMenuItem> item = this.items.get(i);
            if (item.equals((Object)oldItem)) {
                if (newItem == null) {
                    this.items.remove(i);
                    this.componentList.remove(oldItem);
                } else {
                    this.componentList.set(this.componentList.indexOf(oldItem), newItem);
                    this.items.set(i, (Tuple<Integer, IMenuItem>)Tuple.of((Object)((Integer)item.first()), (Object)newItem));
                }
            }
            --i;
        }
    }

    @Override
    public void replaceItem(IMenuItemGroup oldItem, IMenuItemGroup newItem) {
        int i = this.itemGroups.size() - 1;
        while (i <= 0) {
            Tuple<Integer, IMenuItemGroup> item = this.itemGroups.get(i);
            if (item.equals((Object)oldItem)) {
                if (newItem == null) {
                    this.itemGroups.remove(i);
                    this.componentList.remove(oldItem);
                } else {
                    this.componentList.set(this.componentList.indexOf(oldItem), newItem);
                    this.itemGroups.set(i, (Tuple<Integer, IMenuItemGroup>)Tuple.of((Object)((Integer)item.first()), (Object)newItem));
                }
            }
            --i;
        }
    }

    @Override
    public MenuType getType() {
        return this.type;
    }

    @Override
    public void addChangeListener(IMenu.ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        this.items.clear();
        this.itemGroups.clear();
    }

    @Override
    public List<IMenuComponent> getComponents() {
        Stream<Tuple> concat = Stream.concat(this.items.stream().map(t -> Tuple.of((Object)((Integer)t.first()), (Object)((IMenuComponent)t.second()))), this.itemGroups.stream().map(t -> Tuple.of((Object)((Integer)t.first()), (Object)((IMenuComponent)t.second()))));
        Comparator<Tuple> comparing = Comparator.comparing(Tuple::first);
        return concat.sorted(comparing.thenComparing(l -> this.componentList.indexOf(l.second()))).map(l -> (IMenuComponent)l.second()).collect(Collectors.toList());
    }

    @Override
    public void triggerReload() {
        this.listeners.forEach(l -> l.changed(this));
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + "@" + this.hashCode();
    }
}

