/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.MenuAction;
import com.sigge.filerunner.commands.DisplayRemovedTabsAction;
import com.sigge.filerunner.commands.TabCommands;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.editors.AboutDialog;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

@Singleton
public class HelpMenu
implements Provider<IMenu> {
    private final JFrame mainFrame;
    private final TabCommands.DisplayTabsAction displayTabs;
    private final TabCommands.DisplayFrozenTabsAction frozenTabs;
    private final DisplayRemovedTabsAction removedTabs;

    @Inject
    HelpMenu(@Named(value="mainFrame") JFrame mainFrame, TabCommands.DisplayTabsAction displayTabs, TabCommands.DisplayFrozenTabsAction frozenTabs, DisplayRemovedTabsAction removedTabs) {
        this.mainFrame = mainFrame;
        this.displayTabs = displayTabs;
        this.frozenTabs = frozenTabs;
        this.removedTabs = removedTabs;
    }

    public IMenu get() {
        Menu help = new Menu(MenuType.HELP);
        MenuItem newFileItem = new MenuItem(new MenuAction("Show tabs", IconUtils.getSmallIcon("showtabs.png"), (Integer)78, ConfigHandler.getForCommand(this.displayTabs, null), this.displayTabs));
        MenuItem frozenTabsItem = new MenuItem(new MenuAction("Frozen tabs", IconUtils.getSmallIcon("freezetabs.png"), (Integer)70, ConfigHandler.getForCommand(this.displayTabs, null), this.frozenTabs));
        MenuItem removedTabsItem = new MenuItem(new MenuAction("Removed tabs", IconUtils.getSmallIcon("deletetabs.png"), (Integer)82, ConfigHandler.getForCommand(this.displayTabs, null), this.removedTabs));
        help.addItemGroup(new MenuItemGroup(Arrays.asList(newFileItem)), -1);
        help.addItemGroup(new MenuItemGroup(Arrays.asList(frozenTabsItem, removedTabsItem)), -1);
        JMenuItem aboutItem = new JMenuItem(new AbstractAction("About", IconUtils.getSmallIcon("help.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog ad = new AboutDialog(HelpMenu.this.mainFrame, true);
                ad.centerOnCorrectScreen(HelpMenu.this.mainFrame);
                ad.setVisible(true);
            }
        });
        help.addItem(new MenuItem(aboutItem), 0);
        return help;
    }
}

