/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.IconCache;
import com.sigge.filerunner.view.jobs.DefaultJobRenderer;
import com.sigge.filerunner.view.jobs.IJobResult;
import com.sigge.filerunner.view.jobs.JobResultType;
import javax.swing.JLabel;
import javax.swing.JTable;

class JobResultRenderer
extends DefaultJobRenderer {
    JobResultRenderer() {
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof IJobResult) {
            IJobResult result = (IJobResult)value;
            this.setText(result.getResult().getLabel());
            this.setToolTipText(StringUtils.isBlank(result.getResultMessage(), null));
            String icon = result.getResult().getIcon();
            if (icon != null) {
                this.setIcon(IconCache.getCachedSmallIcon(icon));
            }
            if (result.getResult() == JobResultType.RUNNING) {
                this.setFont(this.getFont().deriveFont(1));
            }
        }
        return this;
    }
}

