/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.jobs.JobServerView;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.Binder;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JobEditor {
    private final JFrame mainFrame;

    public JobEditor(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void edit(List<IJobServerManager> managers, List<IJobServer> servers, Optional<IJobServer> selectedServer, boolean add) {
        JobServerView jv = new JobServerView();
        JMemoryDialog jd = new JMemoryDialog(this.mainFrame, "Job editor", false, "job-editor");
        jd.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jd.getContentPane().add(jv);
        jd.pack();
        jd.centerOnCorrectScreen(this.mainFrame);
        jv.saveButton.setEnabled(false);
        ArrayList<IJobServer> jobs = new ArrayList<IJobServer>(servers);
        jobs.add(0, null);
        Binder.bindToCombo(jv.serverList, jobs);
        jv.serverList.setRenderer(new LabelledCellRenderer(true));
        jv.serverList.addItemListener(il -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server != null) {
                new BackgroundRunner(() -> server.getJobs(xxx -> {
                    Binder.bindToCombo((JComboBox)jobServerView.jobListCombo, (List)xxx);
                    this.enableButtons(jv);
                })).execute();
            }
            jobServerView.newButton.setEnabled(server != null);
            jobServerView.duplicateButton.setEnabled(server != null);
        });
        jv.jobListCombo.setRenderer(new LabelledCellRenderer());
        jv.jobListCombo.addItemListener(il -> this.enableButtons(jv));
        selectedServer.ifPresent(jv.serverList::setSelectedItem);
        this.enableButtons(jv);
        ValueHolder job = new ValueHolder();
        jv.newButton.addActionListener(al -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server == null) {
                return;
            }
            job.setValue(server.addJob(jobServerView.mainFramePanel));
            jd.pack();
            jobServerView.saveButton.setEnabled(true);
        });
        jv.editButton.addActionListener(al -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server == null) {
                return;
            }
            IJob current = this.getCurrentJob(jv);
            if (current == null) {
                return;
            }
            job.setValue(current);
            ICommandResult<IJobObject> iCommandResult = server.execute(StandardJobCommand.EDIT, Arrays.asList(current));
        });
        jv.saveButton.addActionListener(al -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server == null) {
                return;
            }
            IJob jobToSave = (IJob)job.getValue();
            if (jobToSave == null) {
                return;
            }
            ArrayList<IJobObject> jobargs = new ArrayList<IJobObject>();
            jobargs.add(jobToSave);
            ICommandResult<IJobObject> execute = server.execute(StandardJobCommand.VALIDATE, jobargs);
            if (!execute.isOK()) {
                return;
            }
            new BackgroundRunner(() -> server.execute(StandardJobCommand.SAVE, jobargs, null), res -> {
                if (res.isOK()) {
                    jd.setVisible(false);
                    jd.dispose();
                }
            }).execute();
        });
        jv.closeButton.addActionListener(al -> {
            jd.setVisible(false);
            jd.dispose();
        });
        SwingUtilities.invokeLater(() -> jobServerView.newButton.doClick());
        jd.setVisible(true);
    }

    private IJob getCurrentJob(JobServerView jv) {
        return (IJob)jv.jobListCombo.getSelectedItem();
    }

    private IJobServer getCurrentJobServer(JobServerView view) {
        return (IJobServer)view.serverList.getSelectedItem();
    }

    private void enableButtons(JobServerView view) {
        Object item = view.jobListCombo.getSelectedItem();
        view.duplicateButton.setEnabled(item != null);
        view.removeButton.setEnabled(item != null);
        view.editButton.setEnabled(item != null);
        view.newButton.setEnabled(this.getCurrentJobServer(view) != null);
        view.revertChangesButton.setEnabled(false);
    }
}

