/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.IIcon;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import com.sigge.filerunner.view.jobs.JobViewModel;
import java.time.LocalDateTime;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;

public class HistoryRenderer
extends VTableCellRenderer {
    public HistoryRenderer() {
        this.putClientProperty("html.disable", Boolean.FALSE);
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 4));
        if (value instanceof LocalDateTime) {
            if (value == JobViewModel.DUMMY_DATE || value == JobViewModel.DUMMY_DATE_MAX) {
                this.setText("");
            } else {
                this.setText(DateUtils.formatLocalDate((LocalDateTime)value, false));
            }
        } else if (value instanceof ILabel) {
            this.setText(((ILabel)value).getLabel());
        }
        if (value instanceof IIcon) {
            IIcon iconValue = (IIcon)value;
            if (StringUtils.isNotEmpty(iconValue.getIcon())) {
                this.setIcon(IconUtils.getSmallIcon(iconValue.getIcon()));
            } else if (iconValue.getColor() != null) {
                this.setText("<html>" + ColorUtils.getColorBlobFromColor(iconValue.getColor()) + this.getText());
            }
        }
        return this;
    }
}

