/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.core.TableRowUtilities;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.editors.TableEditorView;
import com.sigge.filerunner.view.results.EditableResultSetTableModel;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TableEditor {
    private final SQLManager manager;
    private Connection cn;
    private EditableResultSetTableModel rstm;
    private final JFrame mainFrame;
    private static final Logger LOGGER = LoggerFactory.getLogger(TableEditor.class);

    @Inject
    TableEditor(SQLManager manager, @Named(value="mainFrame") JFrame mainFrame) {
        this.manager = manager;
        this.mainFrame = mainFrame;
    }

    public void editTable(SQLObject table, Optional<SQLScriptState> currentScript) {
        this.editTable(this.manager.getSelectRowsSQL(table, 10000), currentScript);
    }

    public void editTable(String query, Optional<SQLScriptState> currentScript) {
        JMemoryFrame jfrey = new JMemoryFrame("Edit table", "tableEditor");
        if (!jfrey.isSizeSetFromSettings()) {
            jfrey.setSize(800, 600);
        }
        TableEditorView tv = new TableEditorView();
        String queryKey = "query";
        JButton refreshButton = tv.getRefreshButton();
        refreshButton.getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), queryKey);
        refreshButton.getInputMap(2).put(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), queryKey);
        tv.setSQL(query);
        jfrey.getContentPane().add(tv);
        ServerDatabase sd = this.manager.getCurrent();
        if (sd == null) {
            return;
        }
        jfrey.setDefaultCloseOperation(2);
        jfrey.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                TableEditor.this.close();
            }
        });
        Runnable action = () -> this.refreshQuery(tv.getSQLToRun(), jfrey, sd, (ThrowingConsumer<EditableResultSetTableModel>)((ThrowingConsumer)e -> SwingUtilities.invokeLater(() -> this.populateTable(tv, (EditableResultSetTableModel)e))));
        refreshButton.getActionMap().put(queryKey, ActionUtils.createAction("Refresh from query", action));
        refreshButton.addActionListener(l -> action.run());
        jfrey.setLocationRelativeTo(new JFrame(this.mainFrame.getGraphicsConfiguration()));
        jfrey.setVisible(true);
        SwingUtilities.invokeLater(action);
    }

    private void populateTable(TableEditorView tv, EditableResultSetTableModel rstm) {
        LOGGER.debug("Populating tv");
        if (rstm == null) {
            return;
        }
        VTable vt = new VTable((TableModel)((Object)rstm), rstm.getTableColumnModel(), rstm.getTableRowSelectionModel());
        vt.setFillsViewportHeight(true);
        vt.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        vt.setAutoResizeMode(0);
        vt.setHorizontalScrollEnabled(true);
        vt.setCellSelectionEnabled(true);
        vt.setColumnSelectionAllowed(true);
        vt.setColumnControlVisible(true);
        vt.setSurrendersFocusOnKeystroke(false);
        vt.setRowHeight(24);
        vt.setEditable(true);
        tv.addTable(vt);
        TableRowUtilities.addNumberColumn((JTable)((Object)vt), 1, true, "Row");
        SwingUtilities.invokeLater(() -> rstm.fireTableDataChanged());
    }

    private void refreshQuery(String query, JMemoryFrame jfrey, ServerDatabase sd, ThrowingConsumer<EditableResultSetTableModel> callback) {
        ThrowingSupplier sup = () -> {
            this.close();
            this.cn = sd.getDb().createConnection(sd.getDatabase(), null);
            Statement st = this.cn.createStatement(1005, 1008);
            ResultSet rs = st.executeQuery(query);
            this.rstm = new EditableResultSetTableModel(rs, new SQLOptions());
            LOGGER.debug("Loaded");
            return this.rstm;
        };
        UIOptionSupplier opt = (UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(sup, callback).mainPanel((RootPaneContainer)jfrey)).exceptionCallback(e -> JOptionPane.showMessageDialog(jfrey, "Exception occured executing sql: " + e.getMessage(), "Error", 0))).build();
        UIBackgroundRunner.execute((UIOptionSupplier)opt);
    }

    private void close() {
        if (this.rstm != null) {
            try {
                this.rstm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rstm = null;
        }
        if (this.cn == null) {
            return;
        }
        try {
            this.cn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

