/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public final class FontUtils {
    private static final int BOLD_ITALIC = 3;
    public static final int DIRTY_STYLE = 1;

    private FontUtils() {
    }

    public static Font getCancelledFont(Font font) {
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        return new Font(attributes);
    }

    public static Font getCancelledFont(Component comp) {
        return FontUtils.getCancelledFont(comp.getFont());
    }

    public static Font getInactiveFont(Font font) {
        return FontUtils.addStyle(font, 2);
    }

    public static Font getInactiveFont(Component comp) {
        return FontUtils.getInactiveFont(comp.getFont());
    }

    public static Font getNonSelectableFont(Font font) {
        return FontUtils.addStyle(font, 2);
    }

    public static Font getNonSelectableFont(Component comp) {
        return FontUtils.getNonSelectableFont(comp.getFont());
    }

    public static Font getDirtyFont(Font font) {
        return FontUtils.addStyle(font, 1);
    }

    public static Font getDirtyFont(Component comp) {
        return FontUtils.getDirtyFont(comp.getFont());
    }

    public static Font addStyle(Font font, int newStyle) {
        int oldStyle = font.getStyle();
        if (oldStyle != newStyle && oldStyle < 3) {
            return font.deriveFont(oldStyle + newStyle);
        }
        return font;
    }

    public static Font getDefaultMonospacedFont() {
        int os = RSyntaxUtilities.getOS();
        if (os == 2) {
            return FontUtils.getDefaultMonospaceFontMacOS();
        }
        if (os == 1) {
            return FontUtils.getDefaultMonospaceFontWindows();
        }
        if (os == 4) {
            return FontUtils.getDefaultMonospaceFontLinux();
        }
        return FontUtils.getDefaultMonospaceFontOther();
    }

    private static Font getDefaultMonospaceFontLinux() {
        Font font = FontUtils.createFont("Ubuntu Mono", 0, 12);
        if (!"Ubuntu Mono".equals(font.getFamily()) && !"DejaVu Sans Mono".equals((font = FontUtils.createFont("DejaVu Sans Mono", 0, 12)).getFamily())) {
            font = FontUtils.getDefaultMonospaceFontOther();
        }
        return font;
    }

    private static Font getDefaultMonospaceFontMacOS() {
        Font font = FontUtils.createFont("Menlo", 0, 12);
        if (!"Menlo".equals(font.getFamily()) && !"Monaco".equals((font = FontUtils.createFont("Monaco", 0, 12)).getFamily())) {
            font = FontUtils.getDefaultMonospaceFontOther();
        }
        return font;
    }

    private static Font getDefaultMonospaceFontOther() {
        return FontUtils.createFont("Monospaced", 0, 13);
    }

    private static Font getDefaultMonospaceFontWindows() {
        Font font = FontUtils.createFont("Cascadia Code", 0, 13);
        if (!"Cascadia Code".equals(font.getFamily()) && !"Consolas".equals((font = FontUtils.createFont("Consolas", 0, 13)).getFamily())) {
            font = FontUtils.getDefaultMonospaceFontOther();
        }
        return font;
    }

    public static Font createFont(String family, int style, int size) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        return sc.getFont(family, style, size);
    }

    public static Font deriveFont(Font baseFont, String newFamily) {
        return FontUtils.deriveFont(baseFont, newFamily, null, null);
    }

    public static Font deriveFont(Font baseFont, String newFamily, Integer newStyle, Number newSize) {
        HashMap<TextAttribute, Object> newAttrs = new HashMap<TextAttribute, Object>();
        if (newFamily != null) {
            newAttrs.put(TextAttribute.FAMILY, newFamily);
        }
        if (newSize != null) {
            newAttrs.put(TextAttribute.SIZE, newSize);
        }
        Font font = newAttrs.isEmpty() ? baseFont : baseFont.deriveFont(newAttrs);
        return newStyle == null ? font : font.deriveFont(newStyle);
    }
}

