/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.Encoding;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.view.core.ButtonTabComponent;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.editors.IEditorHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.DefaultLineDetectionChangeTracker;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.tabs.ColorLabel;
import com.sigge.filerunner.view.tabs.IFilePicker;
import com.sigge.filerunner.view.tabs.ITabEditor;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentDocumentListener;
import com.sigge.filerunner.view.tabs.TextEditor;
import com.sigge.fileutils.FileWatcherService;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTextEditorHandler
implements IEditorHandler<RSyntaxTextArea> {
    private final DnDTabbedPane tab;
    private final Map<Integer, ITabEditor> rmap = new HashMap<Integer, ITabEditor>();
    private final CardHolder<TabContent> holder;
    private final Map<Integer, TabContentDocumentListener> tabContentDocumentListeners = new HashMap<Integer, TabContentDocumentListener>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTextEditorHandler.class);
    private IFilePicker picker;
    private FileWatcherService service;

    @Inject
    public DefaultTextEditorHandler(@Named(value="mainTab") DnDTabbedPane tab, CardHolder<TabContent> holder, IFilePicker saver, FileWatcherService service) {
        this.tab = tab;
        this.holder = holder;
        this.picker = saver;
        this.service = service;
    }

    @Override
    public ITabEditor<RSyntaxTextArea> create(TabContent tc) {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder());
        RSQLSyntaxTextArea rx = new RSQLSyntaxTextArea(tc.getContent(), tc.getContentType());
        rx.discardAllEdits();
        boolean lateload = false;
        TabContentDocumentListener listener = new TabContentDocumentListener(this.holder, (JTabbedPane)this.tab, tc, rx, tc.getContent());
        rx.getDocument().addDocumentListener((DocumentListener)((Object)listener));
        rx.setName(tc.getTitle());
        ComponentUtils.removeTravelsalForComponent((JComponent)((Object)rx), true);
        RTextScrollPane rtxp = new RTextScrollPane((RTextArea)rx);
        ComponentUtils.removeTravelsalForComponent((JComponent)rtxp, true);
        rtxp.setViewportView((Component)((Object)rx));
        rtxp.setPreferredSize(new Dimension(200, 300));
        TextEditor textEditor = new TextEditor(rx, jp);
        this.rmap.put(tc.getId(), textEditor);
        this.tabContentDocumentListeners.put(tc.getId(), listener);
        jp.setLayout(new BorderLayout());
        jp.add((Component)rtxp, "Center");
        ErrorStrip es = new ErrorStrip(rx);
        jp.add((Component)es, "After");
        if (lateload) {
            SwingUtilities.invokeLater(() -> {
                rx.setText(tc.getContent());
                rx.discardAllEdits();
                rx.setEditable(true);
                rx.requestFocusInWindow();
                rx.setCaretPosition(0);
            });
        } else {
            SwingUtilities.invokeLater(() -> {
                rx.requestFocusInWindow();
                rx.setCaretPosition(0);
            });
        }
        return textEditor;
    }

    @Override
    public void replaced(TabContent newElement, TabContent oldElement, int atTabIndex) {
        Integer id = newElement.getId();
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.rmap.get(id).getEditorComponent();
        rSyntaxTextArea.getDocument().removeDocumentListener((DocumentListener)((Object)this.tabContentDocumentListeners.get(id)));
        TabContentDocumentListener listener = new TabContentDocumentListener(this.holder, (JTabbedPane)this.tab, newElement, rSyntaxTextArea, rSyntaxTextArea.getText());
        rSyntaxTextArea.getDocument().addDocumentListener((DocumentListener)((Object)listener));
        this.tabContentDocumentListeners.put(id, listener);
        Component comp = this.tab.getTabComponentAt(atTabIndex);
        ButtonTabComponent buttonComp = new ButtonTabComponent((JTabbedPane)this.tab, new ColorLabel("<html>&nbsp;&nbsp;" + newElement.getTitle() + "&nbsp;&nbsp;"), e -> this.holder.removeAndChangeToPrevious((int)e));
        if (comp instanceof ButtonTabComponent) {
            buttonComp.setLabelBackground(((ButtonTabComponent)comp).getLabelBackground());
        }
        this.tab.setTabComponentAt(atTabIndex, (Component)buttonComp);
        if (newElement.isAFile()) {
            this.tab.setToolTipTextAt(atTabIndex, newElement.getFileName());
        } else {
            this.tab.setToolTipTextAt(atTabIndex, null);
        }
    }

    @Override
    public Optional<File> save(TabContent tc, boolean saveAs, String encoding) throws Exception {
        File fsss;
        File file = fsss = saveAs ? this.picker.saveAs(tc) : this.picker.save(tc);
        if (fsss == null) {
            return Optional.empty();
        }
        this.service.addFileSuspendWatch(fsss);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream fw = new FileOutputStream(fsss);){
            String charsetName = encoding != null ? encoding : (tc.getEncoding() != null ? tc.getEncoding() : Charset.defaultCharset().name());
            Encoding e = Encoding.get(charsetName);
            if (e != null && e.getBom() != Encoding.BOM.NONE) {
                if (e.getBom() == Encoding.BOM.LE) {
                    ((OutputStream)fw).write(new byte[]{-1, -2});
                    if (e == Encoding.UTF32) {
                        ((OutputStream)fw).write(new byte[2]);
                    }
                } else if (e.getBom() == Encoding.BOM.BE) {
                    ((OutputStream)fw).write(new byte[]{-2, -1});
                }
            }
            ((OutputStream)fw).write(this.rmap.get(tc.getId()).getData().getBytes(charsetName));
            if (!tc.isAFile() || saveAs) {
                TabContent newElement = new TabContent(fsss.getName(), fsss.getAbsolutePath(), tc.getContent(), charsetName);
                newElement.assignId(tc.getId());
                this.holder.replaceCurrent(newElement);
            } else {
                this.tabContentDocumentListeners.get(tc.getId()).saved();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Optional.of(fsss);
    }

    @Override
    public boolean supports(TabContent tabContent) {
        return true;
    }

    @Override
    public void deleted(TabContent element) {
        try {
            Integer id = element.getId();
            this.rmap.remove(id);
            this.tabContentDocumentListeners.remove(id);
        }
        catch (Exception ex) {
            LOGGER.error("Exception while deleting", (Throwable)ex);
        }
    }

    @Override
    public TabContent open(File file, Optional<TabContent> existingFileContent) throws Exception {
        Tuple<Integer, Tuple<char[], String>> content = FileUtils.fileContents(file);
        String contentValue = new String((char[])((Tuple)content.second()).first(), 0, (int)((Integer)content.first()));
        if (existingFileContent.isPresent()) {
            TabContent tab = existingFileContent.get();
            RSyntaxTextArea rx = (RSyntaxTextArea)this.rmap.get(tab.getId()).getEditorComponent();
            rx.getDocument().removeDocumentListener((DocumentListener)((Object)this.tabContentDocumentListeners.get(tab.getId())));
            int dot = rx.getCaretLineNumber();
            int dot2 = rx.getCaretOffsetFromLineStart();
            Tuple position = new Tuple((Object)dot, (Object)dot2);
            if (dot != 0 && dot < rx.getLineCount() && ((char[])((Tuple)content.second()).first()).length < 100000) {
                try {
                    DefaultLineDetectionChangeTracker tracker = new DefaultLineDetectionChangeTracker();
                    position = (Tuple)ListUtils.firstNonNullValue((Object[])new Tuple[]{tracker.getPositionAfterChange(rx.getText().toCharArray(), (char[])((Tuple)content.second()).first(), (Tuple<Integer, Integer>)new Tuple((Object)dot, (Object)dot2)), position});
                }
                catch (Exception e) {
                    LOGGER.error("Error while detecting changes", (Throwable)e);
                }
            }
            rx.beginAtomicEdit();
            rx.setText(contentValue);
            TabContentDocumentListener listener = new TabContentDocumentListener(this.holder, (JTabbedPane)this.tab, tab, rx, contentValue);
            this.tabContentDocumentListeners.put(tab.getId(), listener);
            rx.getDocument().addDocumentListener((DocumentListener)((Object)listener));
            try {
                try {
                    Element element = rx.getDocument().getDefaultRootElement().getElement((Integer)position.first());
                    if (element != null) {
                        rx.setCaretPosition(element.getStartOffset() + (Integer)position.second());
                    } else if ((Integer)position.first() > 0 && rx.getDocument().getLength() > 0) {
                        rx.setCaretPosition(rx.getDocument().getLength() - 1);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Setting caret position failed, position was: {}, exception was: {}", (Object)position, (Object)e);
                    rx.setCaretPosition(0);
                    rx.endAtomicEdit();
                }
            }
            finally {
                rx.endAtomicEdit();
            }
            return tab;
        }
        return new TabContent(file.getName(), file.getAbsolutePath(), contentValue, (String)((Tuple)content.second()).second());
    }

    @Override
    public boolean supports(File f) {
        return true;
    }

    @Override
    public boolean isDirty(TabContent tc) {
        TabContentDocumentListener l = this.tabContentDocumentListeners.get(tc.getId());
        return l != null && l.isDirty();
    }
}

