/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.CommandBinding;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.sigge.filerunner.view.editors.BindingView;
import com.sigge.filerunner.view.menu.IMenuRebuilder;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ListModelClass;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.sort.ListSortController;

@Singleton
public class BindingController {
    private final Set<FileRunnerAction> actions;
    private final IMenuRebuilder builder;
    private final JFrame mainFrame;

    @Inject
    public BindingController(Set<FileRunnerAction> actions, IMenuRebuilder builder, @Named(value="mainFrame") JFrame mainFrame) {
        this.actions = actions;
        this.builder = builder;
        this.mainFrame = mainFrame;
    }

    public void present() {
        final BindingView tv = new BindingView();
        final BindingHolder t = new BindingHolder();
        final BindingModel aModel = new BindingModel();
        final Config c = ConfigHandler.getConfig();
        final Map<String, CommandBinding> vals = c.getBindings().stream().collect(Collectors.toMap(CommandBinding::getCommandId, k -> k));
        ArrayList<CommandBinding> cb = new ArrayList<CommandBinding>();
        ArrayList<FileRunnerAction> ac = new ArrayList<FileRunnerAction>(this.actions);
        ac.sort(Comparator.comparing(FileRunnerAction::id));
        for (FileRunnerAction fa : ac) {
            CommandBinding binding = new CommandBinding();
            binding.setCommandId(fa.id());
            CommandBinding defined = vals.get(fa.id());
            binding.setBinding(defined != null ? defined.getBinding() : this.getKeyBindingStringFromKeyStroke(fa.getDefaultKeyStroke()));
            cb.add(binding);
        }
        t.setObjects(cb);
        final AtomicBoolean rebuild = new AtomicBoolean(false);
        APresenter<BindingHolder, BindingModel, BindingView> presenter = new APresenter<BindingHolder, BindingModel, BindingView>(aModel, tv){

            protected void initBindings() {
                this.bind(((BindingView)this.view).bindingField).to(aModel.bindingFriendlyValue);
                this.bind((JList)((BindingView)this.view).commandList).to(aModel.objectsModel);
                RowFilterExtension re = new RowFilterExtension();
                ((BindingView)this.view).commandList.setSortable(true);
                ((BindingView)this.view).commandList.setRowFilter(re);
                ((BindingView)this.view).bindingField.setHint("Press a key combo to generate a binding");
                ((BindingView)this.view).clearBindingButton.addActionListener(l -> ((BindingModel)this.model).binding.setValue((Object)""));
                ((BindingView)this.view).searchField.setHint("Search for commands");
                ((BindingView)this.view).searchField.getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> {
                    String filterText = ((BindingView)this.view).searchField.getText();
                    re.filterOut(((BindingModel)this.model).objectsModel.getObject().stream().filter(v -> v == null || filterText.length() == 0 || v.getCommandId().matches(FilterHelper.getRegexFromString2(filterText))), null);
                    ((BindingView)this.view).commandList.setRowFilter((RowFilter)re);
                    if (((BindingView)this.view).commandList.getSelectedValue() == null && ((BindingView)this.view).commandList.getRowSorter().getViewRowCount() > 0) {
                        ((BindingView)this.view).commandList.setSelectedIndex(0);
                    }
                    ((BindingView)this.view).commandList.ensureIndexIsVisible(((BindingView)this.view).commandList.getSelectedIndex());
                })));
                ((BindingView)this.view).bindingField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        e.consume();
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                        if (e.getModifiersEx() != 0 && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 157) {
                            ((BindingModel)(this).model).binding.setValue((Object)ks.toString());
                        } else if (ks.equals(KeyStroke.getKeyStroke(127, 0)) || ks.equals(KeyStroke.getKeyStroke(8, 0))) {
                            ((BindingModel)(this).model).binding.setValue((Object)"");
                        }
                        e.consume();
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        e.consume();
                    }
                });
                ((BindingView)this.view).closeButton.addActionListener(l -> tv.close());
                ((BindingView)this.view).revertButton.addActionListener(l -> ((BindingModel)this.model).binding.setValue((Object)((CommandBinding)vals.get(((BindingModel)this.model).id.getValue())).getBinding()));
                ((BindingView)this.view).saveButton.addActionListener(l -> {
                    rebuild.set(true);
                    this.saveSettings();
                });
            }

            private void saveSettings() {
                c.setBindings(t.getObjects());
                ConfigHandler.saveInBackground();
            }

            protected void afterObjectSet() {
                ListSortController sorter = new ListSortController(((BindingModel)this.model).objectsModel);
                ((BindingView)this.view).commandList.setCellRenderer((ListCellRenderer)new BindingCellRenderer());
                ((BindingView)this.view).commandList.setRowSorter((RowSorter)sorter);
                if (aModel.objectsModel.getSize() > 0) {
                    aModel.objectsModel.setSelectedItem(aModel.objectsModel.getElementAt(0));
                }
            }
        };
        aModel.binding.addListener(() -> {
            bindingView.statusLabel.setText("");
            String val = (String)bindingModel.binding.getValue();
            if (StringUtils.isNotEmpty(val)) {
                for (CommandBinding cbb : t.getObjects()) {
                    if (Objects.equal((Object)cbb.getCommandId(), (Object)bindingModel.id.getValue()) || cbb.getCommandId() == null || cbb.getBinding() == null || !cbb.getBinding().equals(val)) continue;
                    bindingView.statusLabel.setText("Duplicate binding with \"" + cbb.getCommandId() + "\"");
                    break;
                }
            }
            bindingView.commandList.repaint();
        });
        presenter.setObject((Object)t);
        tv.present(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (rebuild.get()) {
                    BindingController.this.builder.rebuild();
                }
            }
        }, this.mainFrame);
    }

    private String getKeyBindingStringFromKeyStroke(KeyStroke ks) {
        return ks == null ? null : ks.toString();
    }

    private static String formatKey(String key) {
        if (StringUtils.isEmpty(key)) {
            return "";
        }
        return key.replace("pressed ", "").replace("ctrl ", "Ctrl-").replace("alt ", "Alt-").replace("meta ", "Meta-").replace("shift ", "Shift-");
    }

    class BindingCellRenderer
    extends DefaultListCellRenderer {
        BindingCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CommandBinding cb = (CommandBinding)value;
            String val = String.valueOf(cb.getCommandId()) + " binding: " + BindingController.formatKey(StringUtils.isBlank(cb.getBinding(), "<none>"));
            return super.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
        }
    }

    static class BindingHolder
    extends ListModelClass<CommandBinding> {
        BindingHolder() {
        }
    }

    static class BindingModel
    extends AModel<BindingHolder> {
        final IProperty<String> binding = this.getProperty("current.binding");
        final IProperty<String> id = this.getProperty("current.commandId");
        final AModel.BoundedListProperty<CommandBinding> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.binding});
        final APropertyListModel<CommandBinding> objectsModel = new APropertyListModel(this.objects);
        final IProperty<String> bindingFriendlyValue = this.getProperty(e -> {
            if (e.getCurrent() != null && StringUtils.isNotEmpty(((CommandBinding)e.getCurrent()).getBinding())) {
                return BindingController.formatKey(((CommandBinding)e.getCurrent()).getBinding());
            }
            return "";
        });

        BindingModel() {
        }
    }
}

