/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;

public class WheelScrollLayerUI
extends LayerUI<JScrollPane> {
    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(131072L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends JScrollPane> l) {
        Component c = e.getComponent();
        int dir = e.getWheelRotation();
        JScrollPane main = l.getView();
        if (c instanceof JScrollPane && !c.equals(main)) {
            JScrollPane child = (JScrollPane)c;
            BoundedRangeModel m = child.getVerticalScrollBar().getModel();
            int extent = m.getExtent();
            int minimum = m.getMinimum();
            int maximum = m.getMaximum();
            int value = m.getValue();
            if (value + extent >= maximum && dir > 0) {
                main.dispatchEvent(SwingUtilities.convertMouseEvent(c, e, main));
            } else if (value <= minimum && dir < 0) {
                main.dispatchEvent(SwingUtilities.convertMouseEvent(c, e, main));
            }
        }
    }
}

