/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.IconCache;
import com.sigge.filerunner.view.core.IIcon;
import com.sigge.filerunner.view.core.ILabel;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class LabelledCellRenderer
extends DefaultListCellRenderer {
    private final boolean smallIcons;

    public LabelledCellRenderer() {
        this(true);
    }

    public LabelledCellRenderer(boolean smallIcons) {
        this.smallIcons = smallIcons;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel jl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            ImageIcon smallIcon;
            String icon;
            if (value instanceof ILabel) {
                jl.setText(((ILabel)value).getLabel());
            }
            if (value instanceof IIcon && (icon = ((IIcon)value).getIcon()) != null && (smallIcon = this.smallIcons ? IconCache.getCachedSmallIcon(icon) : IconCache.getCachedRegularIcon(icon)) != null) {
                jl.setIcon(smallIcon);
            }
        }
        return jl;
    }
}

