/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.view.core.DialogView;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.search.Searchable;

public class FindColumnAction
extends AbstractAction {
    private final JXTable table;

    public FindColumnAction(JXTable vTable) {
        this.table = vTable;
        this.putValue("Name", "Find column");
        this.putValue("MnemonicKey", 70);
        this.putValue("SwingDisplayedMnemonicIndexKey", 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JXFindBar fb = new JXFindBar(new Searchable(){
            private int lastHighlight;
            private TableCellRenderer tc;
            private Pattern prev;

            public int search(Pattern pattern, int startIndex, boolean backward) {
                TableColumnModel cm = FindColumnAction.this.table.getColumnModel();
                int count = cm.getColumnCount();
                if (pattern == null || cm.getColumnCount() == 0) {
                    return -1;
                }
                boolean samePattern = this.prev != null && this.prev.equals(pattern);
                this.prev = pattern;
                int start = -1;
                if (!backward) {
                    start = startIndex;
                    if (start == -1) {
                        start = 0;
                    } else if (samePattern) {
                        ++start;
                    }
                } else if (startIndex >= 0) {
                    start = startIndex;
                    if (samePattern) {
                        --start;
                    }
                }
                int wrapCount = 0;
                while (true) {
                    if (start == -1) {
                        start = count - 1;
                        ++wrapCount;
                    } else if (start == count) {
                        start = 0;
                        ++wrapCount;
                    }
                    if (wrapCount > 1) {
                        return -1;
                    }
                    if (pattern.matcher(cm.getColumn(start).getIdentifier().toString()).find()) {
                        this.highlightColumn(start);
                        FindColumnAction.this.table.scrollColumnToVisible(start);
                        return start;
                    }
                    if (backward) {
                        --start;
                        continue;
                    }
                    ++start;
                }
            }

            private void highlightColumn(int i) {
                if (this.lastHighlight > -1) {
                    FindColumnAction.this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(this.tc);
                }
                this.lastHighlight = i;
                this.tc = FindColumnAction.this.table.getTableHeader().getColumnModel().getColumn(i).getHeaderRenderer();
                TableCellRenderer tc2 = FindColumnAction.this.table.getTableHeader().getDefaultRenderer();
                TableCellRenderer tc3 = this.tc;
                FindColumnAction.this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HighlightTableCellRenderer(this.tc == null ? tc2 : this.tc));
                FindColumnAction.this.table.getTableHeader().repaint();
                new BackgroundRunner(() -> {
                    Thread.sleep(1500L);
                    SwingUtilities.invokeLater(() -> {
                        FindColumnAction.this.table.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(tc3);
                        FindColumnAction.this.table.getTableHeader().repaint();
                    });
                }).execute();
            }

            public int search(String searchString, int startIndex, boolean backward) {
                return this.search(FilterHelper.getRegexFromString2(searchString), startIndex, backward);
            }

            public int search(Pattern pattern, int startIndex) {
                return this.search(pattern, startIndex, false);
            }

            public int search(String searchString, int startIndex) {
                return this.search(searchString, startIndex, false);
            }

            public int search(Pattern pattern) {
                return this.search(pattern, -1);
            }

            public int search(String searchString) {
                return this.search(searchString, -1);
            }
        });
        JFrame frame = SwingUtilities.getWindowAncestor((Component)this.table) instanceof JFrame ? (JFrame)SwingUtilities.getWindowAncestor((Component)this.table) : null;
        DialogView dv = new DialogView(frame, false);
        dv.setTitle("Find column");
        fb.getActionMap().put("close", null);
        dv.setContent((JPanel)fb, false);
        dv.pack();
        dv.centerOnCorrectScreen(frame);
        dv.setVisible(true);
    }

    class HighlightTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer tc;

        HighlightTableCellRenderer(TableCellRenderer tc) {
            this.tc = tc;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.tc.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }
    }
}

