/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.results.ResultSetEditableTableRenderer;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class AdvancedStringEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JButton BUTTON = new JButton();
    private final JTextArea field = new JTextArea();
    private final EditPanel panel = new EditPanel(this.field, this.BUTTON);
    private final boolean nullAllowed;
    private boolean nullSet = false;
    private boolean editingComp;
    private final ResultSetEditableTableRenderer rr;

    public AdvancedStringEditor(boolean nullAllowed, ResultSetEditableTableRenderer rr) {
        this.nullAllowed = nullAllowed;
        this.rr = rr;
        this.field.getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> {
            boolean bl = this.nullSet = false;
        })));
    }

    @Override
    public boolean stopCellEditing() {
        this.editingComp = false;
        this.BUTTON.setEnabled(false);
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.nullSet ? null : this.field.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.field.setText(value != null ? value.toString() : null);
        this.nullSet = value == null;
        SwingUtilities.invokeLater(this.panel.lookupComponent::requestFocusInWindow);
        this.field.setFont(this.rr.getFont());
        return this.panel;
    }

    public class EditPanel
    extends JPanel {
        private final JComponent lookupComponent;

        public EditPanel(JComponent lookupComponent, final JButton button) {
            this.lookupComponent = lookupComponent;
            this.setLayout(new BorderLayout());
            JScrollPane pane = new JScrollPane(lookupComponent);
            pane.setHorizontalScrollBarPolicy(31);
            this.add((Component)pane, "Center");
            this.add((Component)button, "East");
            button.setEnabled(false);
            button.setFocusable(false);
            button.setText("...");
            this.lookupComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AdvancedStringEditor.this.editingComp = true;
                    button.setEnabled(true);
                    super.mouseReleased(e);
                }
            });
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!AdvancedStringEditor.this.editingComp) {
                        e.consume();
                    }
                    button.setEnabled(true);
                    AdvancedStringEditor.this.editingComp = true;
                    super.mouseReleased(e);
                }
            });
            button.addActionListener(al -> {
                if (!AdvancedStringEditor.this.editingComp) {
                    return;
                }
                final JMemoryDialog jem = new JMemoryDialog(null, "Edit value", false, "editPanel");
                if (jem.isSizeSetFromSettings()) {
                    jem.setSize(new Dimension(600, 480));
                }
                jem.centerOnCorrectScreen(null);
                final RSQLSyntaxTextArea rx = new RSQLSyntaxTextArea(AdvancedStringEditor.this.field.getText(), "text");
                RTextScrollPane rtxp = new RTextScrollPane((RTextArea)rx);
                rtxp.setViewportView((Component)((Object)rx));
                rtxp.setPreferredSize(new Dimension(200, 300));
                rx.discardAllEdits();
                jem.getContentPane().add((Component)rtxp);
                rx.setCaretPosition(0);
                TextPaneUtil.configureSyntaxTextArea(rx);
                JPanel jp = new JPanel();
                if (AdvancedStringEditor.this.nullAllowed) {
                    JButton nullButton = new JButton("Set value to null");
                    jp.add(nullButton);
                    nullButton.addActionListener(l -> {
                        AdvancedStringEditor.this.field.setText(null);
                        AdvancedStringEditor.this.nullSet = true;
                        jem.dispose();
                        AdvancedStringEditor.this.stopCellEditing();
                    });
                }
                JButton ok = new JButton("Save changes");
                jem.getRootPane().setDefaultButton(ok);
                ok.setIcon(IconUtils.getSmallIcon("save.png"));
                JButton discard = new JButton("Discard");
                jp.add(ok);
                jp.add(discard);
                jem.getContentPane().add((Component)jp, "South");
                jem.addCancelAction(discard);
                jem.addOKAction(ok);
                jem.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        if (jem.getReturnStatus() == 1) {
                            AdvancedStringEditor.this.field.setText(rx.getText());
                            AdvancedStringEditor.this.nullSet = false;
                            AdvancedStringEditor.this.stopCellEditing();
                        } else {
                            AdvancedStringEditor.this.cancelCellEditing();
                        }
                    }
                });
                jem.setVisible(true);
            });
        }

        @Override
        public void setFont(Font font) {
            if (this.lookupComponent != null) {
                this.lookupComponent.setFont(font);
            }
        }

        @Override
        public Font getFont() {
            return this.lookupComponent == null ? null : this.lookupComponent.getFont();
        }

        @Override
        public void setBackground(Color bg) {
            if (this.lookupComponent != null) {
                this.lookupComponent.setBackground(bg);
            }
        }

        @Override
        public Color getBackground() {
            return this.lookupComponent == null ? null : this.lookupComponent.getBackground();
        }

        @Override
        public void setForeground(Color fg) {
            if (this.lookupComponent != null) {
                this.lookupComponent.setForeground(fg);
            }
        }

        @Override
        public Color getForeground() {
            return this.lookupComponent == null ? null : this.lookupComponent.getForeground();
        }

        @Override
        public void setBorder(Border border) {
            if (this.lookupComponent != null) {
                this.lookupComponent.setBorder(border);
            }
        }

        @Override
        public Border getBorder() {
            return this.lookupComponent == null ? null : this.lookupComponent.getBorder();
        }
    }
}

