/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;

final class ActivityServerCellRenderer
extends VTableCellRenderer {
    public ActivityServerCellRenderer() {
        this.putClientProperty("html.disable", Boolean.FALSE);
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 4));
        Database d = (Database)value;
        String server = StringUtils.isBlank(d.getServerLabel(), String.valueOf(d.getUser() != null ? String.valueOf(d.getUser()) + "@" : "") + d.getServer());
        String blob = DatabaseUtils.getColorBlob(d);
        if (blob != null && !blob.isEmpty()) {
            server = "<html>" + blob + server + "</html>";
        }
        this.setText(server);
        return this;
    }
}

