/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;

public class ActivityCleaner
implements Closeable {
    private final List<Runnable> cleanup = new ArrayList<Runnable>();

    public void addAction(AbstractButton ab, Action aa) {
        ab.setAction(aa);
        this.cleanup.add(() -> ab.setAction(null));
    }

    public void addChangeListener(JSpinner spinner, ChangeListener cl) {
        spinner.getModel().addChangeListener(cl);
        this.cleanup.add(() -> spinner.getModel().removeChangeListener(cl));
    }

    public void addTableListener(JTable table, TableModelListener listener) {
        table.getModel().addTableModelListener(listener);
        this.cleanup.add(() -> table.getModel().removeTableModelListener(listener));
    }

    public void addTableSelectionListener(JTable table, ListSelectionListener listener) {
        table.getSelectionModel().addListSelectionListener(listener);
        this.cleanup.add(() -> table.getSelectionModel().removeListSelectionListener(listener));
    }

    @Override
    public void close() throws IOException {
        for (Runnable r : this.cleanup) {
            try {
                r.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cleanup.clear();
    }
}

