/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.ISQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.RunningTabContent;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetPresenter;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

@Singleton
public final class TabContentCellRenderer
extends DefaultListCellRenderer {
    private final CardHolder<TabContent> tabHolder;
    private final ISQLManager sqlManager;
    private static final ImageIcon FOLDER_ICON = IconUtils.getSmallIcon("folder.png");
    private static final ImageIcon TEXT_ICON = IconUtils.getSmallIcon("text.png");
    private static final ImageIcon RUNNING_ICON = IconUtils.getSmallIcon("flash.png");

    @Inject
    public TabContentCellRenderer(CardHolder<TabContent> tabHolder, ISQLManager sqlManager) {
        this.tabHolder = tabHolder;
        this.sqlManager = sqlManager;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        TabContent tc = (TabContent)value;
        JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        l.setText(this.getTitle(tc, list));
        l.setToolTipText(tc.isAFile() ? tc.getFileName() : tc.getTitle());
        if (Objects.equal((Object)this.tabHolder.current(), (Object)tc)) {
            l.setFont(l.getFont().deriveFont(1));
        } else {
            l.setFont(l.getFont().deriveFont(0));
        }
        if (tc instanceof RunningTabContent) {
            if (((RunningTabContent)tc).isRunning()) {
                l.setIcon(RUNNING_ICON);
                l.setToolTipText("Executing query..." + l.getToolTipText());
            } else {
                l.setIcon(tc.isAFile() ? FOLDER_ICON : TEXT_ICON);
            }
        } else {
            l.setIcon(tc.isAFile() ? FOLDER_ICON : TEXT_ICON);
        }
        return l;
    }

    private Optional<SQLScriptState> getState(TabContent tc) {
        return Optional.ofNullable(this.sqlManager.getForTab(tc));
    }

    String getTitle(TabContent tc, JList list) {
        Optional<Integer> rows;
        String db = "";
        String prefix = "";
        Optional<SQLScriptState> state = this.getState(tc);
        List dbs = state.map(SQLScriptState::getCurrentDatabases).orElse(null);
        List models = state.map(SQLScriptState::getResultSetPresenter).map(ResultSetPresenter::getResults).orElse(Collections.EMPTY_LIST);
        if (dbs != null && dbs.size() > 0) {
            String blob;
            ServerDatabase value = (ServerDatabase)dbs.get(0);
            String server = value == null || value.getDb() == null ? "" : " <font color=blue>" + StringUtils.isBlank(value.getDb().getServerLabel(), String.valueOf(value.getDb().getUser()) + "@" + value.getDb().getServer()) + "</font>";
            prefix = "<html>";
            if (value != null && value.getDb() != null && (blob = DatabaseUtils.getColorBlob(value.getDb())).length() > 0) {
                prefix = String.valueOf(prefix) + blob;
            }
            db = "&nbsp;" + (value != null ? value.getDatabase() : "") + server;
        }
        String id = "";
        IScriptRunner ss = this.getState(tc).map(SQLScriptState::getScriptRunner).orElse(null);
        if (ss != null) {
            try {
                String sessionId = ss.getSessionId();
                if (sessionId != null) {
                    id = " [" + sessionId + "]";
                }
            }
            catch (Exception sessionId) {
                // empty catch block
            }
        }
        if ((rows = models.stream().map(Tuple::second).map(IResultSetTable::getRowCount).reduce((i, j) -> i + j)).orElse(0) > 0) {
            id = String.valueOf(id) + " Rows: " + rows.get() + (models.size() > 1 ? ", results: " + models.size() + "," : "");
        }
        if (!tc.isAFile()) {
            return String.valueOf(prefix) + tc.getTitle() + id + db;
        }
        File f = new File(tc.getFileName());
        String file = f.getName();
        String rest = StringUtils.isBlank(f.getParent(), "");
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        String output = String.valueOf(rest) + File.separator + file + id + db;
        int width = metrics.stringWidth(output) + 50;
        int listWidth = (int)Math.min(list.getSize().getWidth(), list.getParent().getBounds().getWidth());
        if (listWidth < width) {
            rest = StringUtils.isBlank(f.getParent(), "");
            int restChars = (int)((double)output.length() * (1.0 - (double)listWidth / ((double)width * 1.2)));
            rest = restChars > rest.length() ? "" : rest.substring(restChars);
            return String.valueOf(prefix) + "..." + rest + File.separator + file + id + db;
        }
        return String.valueOf(prefix) + output;
    }
}

