/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.RunnerView;
import com.sigge.filerunner.view.core.CaretStateUpdate;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import com.siggemannen.core.Tuple;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

@Singleton
public class StatusUpdater
implements CaretStateUpdate.CaretStateUpdateListener,
IStatusUpdater {
    private final RunnerView view;
    private CaretStateUpdate caretState;
    private final RunnerModel model;
    private final Map<String, Tuple<String, String>> messages = new LinkedHashMap<String, Tuple<String, String>>();

    @Inject
    public StatusUpdater(RunnerView view, RunnerModel model) {
        this.view = view;
        this.model = model;
    }

    @Override
    public void caretStateUpdate(CaretStateUpdate state) {
        this.caretState = state;
        this.updateStatusBarInner();
    }

    @Override
    public String addMessage(String message, String sourceTag) {
        return this.addMessage(message, sourceTag, 0);
    }

    @Override
    public String addMessage(String message, String sourceTag, int autoRemovalTime) {
        String id = UUID.randomUUID().toString();
        this.getMessages().put(sourceTag, (Tuple<String, String>)Tuple.of((Object)id, (Object)message));
        this.updateStatusBar();
        if (autoRemovalTime > 0) {
            AccumulatedBackgroundRunner.schedule((String)("remove-" + sourceTag), () -> this.removeMessage(sourceTag), (int)autoRemovalTime, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return id;
    }

    @Override
    public synchronized void removeMessage(String sourceTag) {
        this.getMessages().remove(sourceTag);
        this.updateStatusBar();
    }

    @Override
    public synchronized void removeMessageById(String id) {
        for (String key : this.getMessages().keySet()) {
            if (!((String)this.messages.get(key).first()).equals(id)) continue;
            this.messages.remove(key);
            this.updateStatusBar();
            break;
        }
    }

    private void updateStatusBar() {
        SwingUtilities.invokeLater(this::updateStatusBarInner);
    }

    private void updateStatusBarInner() {
        StringBuilder sb = new StringBuilder("<html><font style='font-size:10px'>");
        StringBuilder sbToolTip = new StringBuilder("<html><font style='font-size:10px'>");
        String encoding = this.caretState == null || this.caretState.getTabContent() == null ? "" : StringUtils.isBlank(this.caretState.getTabContent().getEncoding(), "UTF-8");
        sb.append(encoding);
        sb.append("&nbsp;|&nbsp;");
        if (this.getMessages().size() > 0) {
            String join = String.join((CharSequence)", ", this.messages.values().stream().map(Tuple::second).collect(Collectors.toList()));
            if (join.replace("&nbsp;", " ").length() > 150) {
                sb.append(StringUtils.abbreviate(join.replace("&nbsp;", " "), 150));
            } else {
                sb.append(join);
            }
            sbToolTip.append(String.join((CharSequence)"<br>", this.messages.values().stream().map(Tuple::second).collect(Collectors.toList())));
            sb.append(" | ");
        }
        if (this.caretState != null) {
            this.model.getSelectedScript().setValue((Object)this.caretState.getSelection());
            this.model.getCursorToken().setValue((Object)this.caretState.getTokenAtCursor());
            if (sb.length() > 0) {
                sb.append("  ");
            }
            String label = String.format("Line: %d  Column: %d  %s%s | Position: %d | %s", this.caretState.getLineNumber(), this.caretState.getColNumber(), this.caretState.getSelectionLength() > 0 ? "| Selection: " + this.caretState.getSelectionLength() + " " : "", this.caretState.getSelectedLines() > 1 ? "Lines " + this.caretState.getSelectedLines() : "", this.caretState.getCharNumber(), this.caretState.getNewLineAtLine());
            sb.append(label);
            sbToolTip.append(label);
        }
        sb.append("</font></html>");
        sbToolTip.append("</font></html>");
        this.view.getStatusLabel().setText(sb.toString());
        this.view.getStatusLabel().setToolTipText(sbToolTip.toString());
    }

    private synchronized Map<String, Tuple<String, String>> getMessages() {
        return this.messages;
    }
}

