/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon getIcon(String filename) {
        try (InputStream stream = IconUtils.class.getResourceAsStream("results/resources/" + filename);){
            ImageIcon imageIcon = new ImageIcon(ImageIO.read(stream));
            return imageIcon;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get icon for " + filename, e);
        }
    }

    public static URL getLargeIconUrl(String filename) {
        return IconUtils.class.getResource("results/resources/large/" + filename);
    }

    public static ImageIcon getSmallIcon(String filename) {
        return IconUtils.getIcon("small/" + filename);
    }

    public static ImageIcon getAnimatedIcon(String filename) {
        URL url = IconUtils.class.getResource("results/resources/" + filename);
        return new ImageIcon(url);
    }

    public static ImageIcon getSmallAnimatedIcon(String filename) {
        return IconUtils.getAnimatedIcon("small/" + filename);
    }
}

