/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.sigge.filerunner.view.IconUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;

public class IconCache {
    private static final String LARGE_PREFIX = "large";
    private static final String SMALL_PREFIX = "small";
    private static final String REGULAR_PREFIX = "";
    private static final Map<String, Map<String, ImageIcon>> imageCache = new HashMap<String, Map<String, ImageIcon>>();

    static {
        imageCache.put(SMALL_PREFIX, new ConcurrentHashMap());
        imageCache.put(LARGE_PREFIX, new ConcurrentHashMap());
        imageCache.put(REGULAR_PREFIX, new ConcurrentHashMap());
    }

    public static void flush() {
        imageCache.get(SMALL_PREFIX).clear();
        imageCache.get(LARGE_PREFIX).clear();
        imageCache.get(REGULAR_PREFIX).clear();
    }

    public static ImageIcon getCachedSmallIcon(String icon) {
        return imageCache.get(SMALL_PREFIX).computeIfAbsent(icon, f -> IconUtils.getSmallIcon(icon));
    }

    public static ImageIcon getCachedRegularIcon(String icon) {
        return imageCache.get(REGULAR_PREFIX).computeIfAbsent(icon, f -> IconUtils.getIcon(icon));
    }
}

