/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.sigge.filerunner.view.FileToRun;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FilesToRunTablePopulator {
    public static List<FileToRun> processFileOrFolder(List<File> folder) {
        try {
            ArrayList<FileToRun> files = new ArrayList<FileToRun>();
            for (File fileOrFolder : folder) {
                if (!fileOrFolder.exists()) continue;
                if (fileOrFolder.isFile()) {
                    files.add(new FileToRun(fileOrFolder.getName(), fileOrFolder.getAbsolutePath()));
                    continue;
                }
                files.addAll(Files.walk(Paths.get(fileOrFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(FilesToRunTablePopulator::isSQL).map(f -> new FileToRun(f.toFile().getName(), f.toFile().getPath())).collect(Collectors.toList()));
            }
            return files;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception processing folder", e);
        }
    }

    private static boolean isSQL(Path p) {
        String name = p.toFile().getName();
        if (name.length() < 4) {
            return false;
        }
        return name.substring(name.length() - 4).toLowerCase().equals(".sql");
    }
}

