/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.select.source;

import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.select.source.Source;
import com.sigge.filerunner.sql.transform.select.source.TableSource;
import com.sigge.filerunner.sql.transform.select.source.join.Apply;
import com.sigge.filerunner.sql.transform.select.source.join.BaseJoin;
import com.sigge.filerunner.sql.transform.select.source.join.CrossJoin;
import com.sigge.filerunner.sql.transform.select.source.join.FullJoin;
import com.sigge.filerunner.sql.transform.select.source.join.InnerJoin;
import com.sigge.filerunner.sql.transform.select.source.join.JoinExpression;
import com.sigge.filerunner.sql.transform.select.source.join.LeftJoin;
import com.sigge.filerunner.sql.transform.select.source.join.Pivot;
import com.sigge.filerunner.sql.transform.select.source.join.RightJoin;
import com.sigge.filerunner.sql.transform.select.source.join.Unpivot;
import com.siggemannen.sql.antler.TSqlParser;
import org.antlr.v4.runtime.tree.ParseTree;

public class JoinPart
extends BaseExpression {
    private JoinExpression join;

    public JoinPart(JoinExpression join) {
        super(join.getTree());
        this.join = join;
    }

    public JoinPart(TSqlParser.Join_partContext pt, TableSource parent) {
        super((ParseTree)pt);
        TSqlParser.UnpivotContext unpivot;
        TSqlParser.PivotContext pivot;
        TSqlParser.ApplyContext apply;
        TSqlParser.Join_onContext joinOn = pt.join_on();
        if (joinOn != null) {
            if (joinOn.inner != null) {
                this.join = new InnerJoin(joinOn, parent);
            } else if (joinOn.join_type != null) {
                switch (joinOn.join_type.getType()) {
                    case 97: {
                        this.join = new LeftJoin(joinOn, parent);
                        break;
                    }
                    case 146: {
                        this.join = new RightJoin(joinOn, parent);
                        break;
                    }
                    case 74: {
                        this.join = new FullJoin(joinOn, parent);
                    }
                }
            } else {
                this.join = new BaseJoin(joinOn, parent);
            }
            return;
        }
        TSqlParser.Cross_joinContext cross = pt.cross_join();
        if (cross != null) {
            this.join = new CrossJoin(cross, parent);
        }
        if ((apply = pt.apply()) != null) {
            this.join = new Apply(apply, parent);
        }
        if ((pivot = pt.pivot()) != null) {
            this.join = new Pivot(pivot, parent);
        }
        if ((unpivot = pt.unpivot()) != null) {
            this.join = new Unpivot(unpivot, parent);
        }
    }

    public Source getJoinSource() {
        if (this.join != null && this.join.getJoinSource() != null) {
            return this.join.getJoinSource().getTableSourceItem();
        }
        return null;
    }

    public JoinExpression getJoin() {
        return this.join;
    }
}

