/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.expression;

import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.LogicalAndExpression;
import com.sigge.filerunner.sql.transform.expression.LogicalOrExpression;
import com.sigge.filerunner.sql.transform.expression.NotExpression;
import com.sigge.filerunner.sql.transform.expression.PredicateExpression;
import java.util.ArrayList;
import java.util.List;

public class SearchConditionNot
extends Expression {
    private boolean not;
    private PredicateExpression pe;
    private final List<LogicalSearch> searches = new ArrayList<LogicalSearch>();
    LogicalOp logicalOp = null;

    @Override
    public Expression aggregate(Expression nextResult) {
        if (nextResult instanceof NotExpression) {
            this.not = !this.not;
        } else if (nextResult instanceof PredicateExpression) {
            this.pe = (PredicateExpression)nextResult;
        } else if (nextResult instanceof LogicalAndExpression) {
            this.logicalOp = new And();
        } else if (nextResult instanceof LogicalOrExpression) {
            this.logicalOp = new Or();
        } else if (nextResult instanceof SearchConditionNot) {
            LogicalSearch ls = new LogicalSearch(this.logicalOp, (SearchConditionNot)nextResult);
            this.searches.add(ls);
        }
        this.expressions.add(nextResult);
        return this;
    }

    private class LogicalSearch {
        private final LogicalOp op;
        private final SearchConditionNot sc;

        private LogicalSearch(LogicalOp op, SearchConditionNot sc) {
            this.op = op;
            this.sc = sc;
        }
    }

    private class And
    extends LogicalOp {
        private And() {
        }
    }

    private class Or
    extends LogicalOp {
        private Or() {
        }
    }

    private class LogicalOp {
        private LogicalOp() {
        }
    }
}

