/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.dml;

import com.sigge.filerunner.sql.transform.dml.SelectQuery;
import com.sigge.filerunner.sql.transform.dml.SelectStatementVisitor;
import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.siggemannen.sql.antler.TSqlParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public class UnionExpression
extends BaseExpression {
    private TerminalNode operator;
    private TerminalNode all;
    private final UnionOperator type;
    private SelectQuery query;

    public UnionExpression(TSqlParser.Sql_unionContext pt) {
        super((ParseTree)pt);
        TerminalNode union = pt.UNION();
        TerminalNode all = pt.ALL();
        TerminalNode except = pt.EXCEPT();
        TerminalNode intersect = pt.INTERSECT();
        if (union != null) {
            if (all != null) {
                this.type = UnionOperator.UNION_ALL;
                this.all = all;
            } else {
                this.type = UnionOperator.UNION;
            }
            this.operator = union;
        } else if (except != null) {
            this.type = UnionOperator.EXCEPT;
            this.operator = except;
        } else if (intersect != null) {
            this.type = UnionOperator.INTERSECT;
            this.operator = intersect;
        } else {
            this.type = null;
        }
        if (pt.spec != null) {
            this.query = (SelectQuery)pt.spec.accept((ParseTreeVisitor)new SelectStatementVisitor());
        } else if (pt.op != null) {
            this.query = (SelectQuery)pt.op.accept((ParseTreeVisitor)new SelectStatementVisitor());
        }
    }

    public SelectQuery getQuery() {
        return this.query;
    }

    public UnionOperator getType() {
        return this.type;
    }

    private static enum UnionOperator {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

