/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.dml;

import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.expression.scalars.ConstantVisitor;
import com.sigge.filerunner.sql.transform.expression.scalars.VariableExpression;
import com.sigge.filerunner.sql.transform.parameter.ParameterValue;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execute
extends BaseExpression
implements Clause {
    private final Token execute;
    private final TSqlParser.Execute_bodyContext body;
    private final List<Expression> dynExec = new ArrayList<Expression>();
    private final Expression procName;
    private final TSqlParser.Execute_statement_argContext params;
    private final List<ParameterValue> parameters = new ArrayList<ParameterValue>();
    private static final Logger LOGGER = LoggerFactory.getLogger(Execute.class);
    private final VariableExpression returnValue;

    public Execute(TSqlParser.Execute_body_batchContext pt) {
        super((ParseTree)pt);
        this.execute = null;
        this.body = null;
        this.returnValue = null;
        TSqlParser.Func_proc_name_server_database_schemaContext func = pt.func_proc_name_server_database_schema();
        this.procName = func != null ? new SQLName(func) : null;
        this.params = pt.execute_statement_arg();
        this.extractParams();
    }

    public Execute(TSqlParser.Execute_statementContext pt) {
        super((ParseTree)pt);
        this.execute = this.getSafeToken(pt.EXECUTE());
        this.body = pt.execute_body();
        if (this.body != null) {
            if (this.body.dyn_paren_start != null) {
                for (TSqlParser.Primitive_expressionContext x : this.body.exec_string) {
                    Expression varString = this.getFromVarString(x);
                    if (varString == null) continue;
                    this.dynExec.add(varString);
                }
                this.procName = null;
                this.returnValue = null;
            } else {
                TSqlParser.Func_proc_name_server_database_schemaContext func_proc_name_server_database_schema = this.body.func_proc_name_server_database_schema();
                this.procName = this.body.spName != null ? new VariableExpression(this.body.spName) : (func_proc_name_server_database_schema != null ? new SQLName(func_proc_name_server_database_schema) : null);
                Token t = this.body.return_status;
                this.returnValue = t != null ? new VariableExpression(t) : null;
            }
        } else {
            this.procName = null;
            this.returnValue = null;
        }
        this.params = this.body.execute_statement_arg();
        this.extractParams();
    }

    private void extractParams() {
        TSqlParser.Execute_statement_argContext loopParams = this.params;
        int arg = 0;
        if (loopParams != null) {
            for (TSqlParser.Execute_statement_arg_named_or_unnamedContext pr : loopParams.execute_statement_arg_named_or_unnamed()) {
                TSqlParser.Execute_statement_arg_unnamedContext unnamed = pr.execute_statement_arg_unnamed();
                if (unnamed != null) {
                    ParameterValue param = new ParameterValue(unnamed, arg);
                    ++arg;
                    this.parameters.add(param);
                    continue;
                }
                TSqlParser.Execute_statement_arg_namedContext named = pr.execute_statement_arg_named();
                if (named == null) continue;
                ParameterValue param = new ParameterValue(named, arg);
                ++arg;
                this.parameters.add(param);
            }
        }
    }

    private Expression getFromVarString(TSqlParser.Primitive_expressionContext var) {
        TerminalNode local_ID = var.LOCAL_ID();
        if (local_ID != null) {
            return new VariableExpression(local_ID);
        }
        if (var.constant() != null) {
            return (Expression)new ConstantVisitor().visit((ParseTree)var.constant());
        }
        return null;
    }

    @Override
    public ParserRuleContext getContext() {
        return this.getTreeAsContext();
    }

    public Expression getProcName() {
        return this.procName;
    }

    public TSqlParser.Execute_statement_argContext getParams() {
        return this.params;
    }

    public List<ParameterValue> getParameters() {
        return this.parameters;
    }

    public Token getExecute() {
        return this.execute;
    }

    public VariableExpression getReturnValue() {
        return this.returnValue;
    }
}

