/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.run;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.run.IDebugVariable;
import com.sigge.filerunner.sql.run.IDebuggerSession;
import com.sigge.filerunner.sql.run.IDebuggingContext;
import com.sigge.filerunner.sql.run.IFrame;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.SQLServerParserWalkerListener;
import com.sigge.filerunner.sql.sqlserver.parser.GO;
import com.sigge.filerunner.sql.sqlserver.parser.SQLRuleVisitor;
import com.sigge.filerunner.sql.sqlserver.run.DebugScope;
import com.sigge.filerunner.sql.sqlserver.run.Frame;
import com.sigge.filerunner.sql.sqlserver.run.SQLServerClauseTransformer;
import com.sigge.filerunner.sql.sqlserver.run.StackFrame;
import com.sigge.filerunner.sql.transform.Batch;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.Scope;
import com.siggemannen.sql.antler.CaseChangingCharStreamUpper;
import com.siggemannen.sql.antler.TSqlLexer;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;

public class DebuggerSession
implements IDebuggerSession {
    private final ServerDatabase database;
    private final IScriptRunner runner;
    private final String codez;
    TSqlLexer lt;
    TSqlParser tp;
    private SQLServerParserWalkerListener listener;
    private final SQLFile file;
    private final DebugScope currentScope;
    Stack<DebugScope> scopes = new Stack();
    List<Clause> clauses;
    int currentClause = -1;
    private StackFrame sf;
    private final IDebuggingContext debugContext;

    public DebuggerSession(ServerDatabase database, IScriptRunner runner, String codez, IDebuggingContext debugContext) {
        this.database = database;
        this.runner = runner;
        this.codez = codez;
        this.debugContext = debugContext;
        this.currentScope = new DebugScope();
        this.scopes.push(this.currentScope);
        this.initParsers();
        CodePointCharStream s = CharStreams.fromString((String)codez);
        CaseChangingCharStreamUpper upper = new CaseChangingCharStreamUpper((CharStream)s);
        this.lt.setInputStream((IntStream)upper);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lt);
        this.tp.setTokenStream((TokenStream)tokens);
        this.listener.reset();
        this.file = (SQLFile)new SQLRuleVisitor().visit((ParseTree)this.tp.tsql_file());
        this.sf = new StackFrame(this.file);
        ClauseUtility.walk(this.file, (a, b, c) -> {
            System.out.println("Clause: " + TSqlParser.ruleNames[a.getContext().getRuleIndex()] + ", " + a + ", level:" + c);
            return true;
        });
    }

    private void initParsers() {
        this.lt = new TSqlLexer(null);
        this.tp = new TSqlParser(null);
        this.lt.removeErrorListeners();
        this.tp.removeErrorListeners();
        this.tp.setTrace(false);
        this.tp.setProfile(false);
        ((ParserATNSimulator)this.tp.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        this.tp.setBuildParseTree(true);
        this.listener = new SQLServerParserWalkerListener();
        this.lt.addErrorListener((ANTLRErrorListener)this.listener);
        this.tp.addErrorListener((ANTLRErrorListener)this.listener);
    }

    @Override
    public ServerDatabase getCurrentDatabase() {
        return this.database;
    }

    @Override
    public IFrame getFrame() {
        return this.sf.getCurrent().getFrame();
    }

    public IScriptRunner getRunner() {
        return this.runner;
    }

    @Override
    public boolean step() throws Exception {
        Optional<Clause> c;
        SQLServerClauseTransformer transformer;
        StackFrame.ScopeClauses current = this.sf.getCurrent();
        IFrame frame = current.getFrame();
        Scope s = current.getScope();
        boolean theEnd = this.sf.nextStatement();
        if (theEnd) {
            return false;
        }
        ArrayList<IDebugVariable> vars = new ArrayList<IDebugVariable>();
        StackFrame.ScopeClauses newCurrent = this.sf.getCurrent();
        if (s.equals(newCurrent.getScope())) {
            vars.addAll(frame.getVariables());
            if (newCurrent.getTransformer() == null) {
                transformer = new SQLServerClauseTransformer(this.runner, this.debugContext);
                newCurrent.setTransformer(transformer);
            }
        } else {
            transformer = new SQLServerClauseTransformer(this.runner, this.debugContext);
            newCurrent.setTransformer(transformer);
        }
        if ((c = newCurrent.getClause()).isPresent()) {
            Clause clause = c.get();
            if (clause instanceof Batch) {
                Frame f = new Frame(newCurrent.getScope(), clause, vars);
                newCurrent.setFrame(f);
                return true;
            }
            if (clause instanceof GO) {
                Frame f = new Frame(newCurrent.getScope(), clause, Collections.EMPTY_LIST);
                newCurrent.setFrame(f);
                return true;
            }
            IFrame newFrame = newCurrent.getTransformer().evaluate(clause, frame);
            newCurrent.setFrame(newFrame);
        }
        return true;
    }

    @Override
    public void run() {
    }

    @Override
    public void toggleBreak(int position) {
    }

    @Override
    public void release() {
    }

    @Override
    public void edit(String newCode) {
    }

    @Override
    public void evaluate(String code) {
    }
}

