/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.parser.ddl;

import com.sigge.filerunner.sql.ddl.DDLClause;
import com.sigge.filerunner.sql.ddl.DDLObject;
import com.sigge.filerunner.sql.ddl.DDLOperation;
import com.sigge.filerunner.sql.ddl.ISQLObjectType;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.ColumnOrder;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.DDLObjectType;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;

public class CreateIndex
extends DDLClause {
    private final boolean clustered;
    private final boolean nonclustered;
    private final boolean unique;
    private final SQLName indexName;
    private final SQLName tableName;
    private final List<ColumnOrder> columns = new ArrayList<ColumnOrder>();
    private final List<SQLName> columnsInclude = new ArrayList<SQLName>();

    public CreateIndex(TSqlParser.Create_indexContext context) {
        super((ParserRuleContext)context);
        this.setDdlOperation(DDLOperation.CREATE);
        TSqlParser.ClusteredContext cc = context.clustered();
        if (cc != null) {
            if (cc.CLUSTERED() != null) {
                this.clustered = true;
                this.nonclustered = false;
            } else if (cc.NONCLUSTERED() != null) {
                this.clustered = false;
                this.nonclustered = true;
            } else {
                this.clustered = false;
                this.nonclustered = false;
            }
        } else {
            this.clustered = false;
            this.nonclustered = false;
        }
        this.unique = context.UNIQUE() != null;
        this.indexName = context.index_name != null ? new SQLName(context.index_name) : null;
        this.tableName = context.index_table_name != null ? new SQLName(context.index_table_name) : null;
        this.setDdlObject(new Index(this.indexName));
        if (context.column_name_index != null) {
            for (TSqlParser.Column_name_with_orderContext col : context.column_name_index.col_name_order) {
                if (col == null) continue;
                this.columns.add(new ColumnOrder(col));
            }
        }
        if (context.column_name_include != null) {
            for (TSqlParser.Column_name_with_orderContext col : context.column_name_include.col) {
                if (col == null) continue;
                this.columnsInclude.add(new SQLName((TSqlParser.IdContext)col));
            }
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isNonclustered() {
        return this.nonclustered;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public SQLName getIndexName() {
        return this.indexName;
    }

    public SQLName getTableName() {
        return this.tableName;
    }

    public List<ColumnOrder> getColumns() {
        return this.columns;
    }

    public List<SQLName> getColumnsInclude() {
        return this.columnsInclude;
    }

    public static class Index
    implements DDLObject {
        private final SQLName name;

        Index(SQLName name) {
            this.name = name;
        }

        @Override
        public SQLName getName() {
            return this.name;
        }

        @Override
        public ISQLObjectType getObjectType() {
            return DDLObjectType.INDEX;
        }
    }
}

