/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.parser;

import com.sigge.filerunner.sql.sqlserver.parser.SQLRuleVisitor;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.Statements;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class Trigger
extends Statements {
    private final ParserRuleContext trigger;
    private final SQLName name;
    private final TriggerType type;
    private final SQLName triggerTarget;
    private final List<TriggerActionType> action = new ArrayList<TriggerActionType>();
    private TriggerSubType subType;

    public Trigger(TSqlParser.CREATE_TRIGGERContext trigger) {
        TSqlParser.Create_or_alter_triggerContext create_or_alter_trigger = trigger.create_or_alter_trigger();
        this.trigger = create_or_alter_trigger;
        TSqlParser.Create_or_alter_ddl_triggerContext ddlTrigger = create_or_alter_trigger.create_or_alter_ddl_trigger();
        TSqlParser.Create_or_alter_dml_triggerContext dmlTrigger = create_or_alter_trigger.create_or_alter_dml_trigger();
        if (ddlTrigger != null) {
            this.type = TriggerType.DDL;
            this.name = new SQLName(ddlTrigger.trig_name);
            for (TSqlParser.Sql_clausesContext clause : ddlTrigger.sql_clauses()) {
                this.addClause((Clause)new SQLRuleVisitor().visit((ParseTree)clause));
            }
            this.triggerTarget = null;
        } else if (dmlTrigger != null) {
            this.type = TriggerType.DML;
            this.name = new SQLName(dmlTrigger.trig_name);
            for (TSqlParser.Sql_clausesContext clause : dmlTrigger.sql_clauses()) {
                this.addClause((Clause)new SQLRuleVisitor().visit((ParseTree)clause));
            }
            for (TSqlParser.Dml_trigger_operationContext x : dmlTrigger.dml_trigger_operation()) {
                if (x.DELETE() != null) {
                    this.action.add(TriggerActionType.DELETE);
                    continue;
                }
                if (x.UPDATE() != null) {
                    this.action.add(TriggerActionType.UPDATE);
                    continue;
                }
                if (x.INSERT() == null) continue;
                this.action.add(TriggerActionType.INSERT);
            }
            this.triggerTarget = dmlTrigger.table != null ? new SQLName(dmlTrigger.table) : null;
        } else {
            this.type = TriggerType.UNKNOWN;
            this.name = null;
            this.triggerTarget = null;
        }
    }

    @Override
    public ParserRuleContext getContext() {
        return this.trigger;
    }

    public TriggerType getType() {
        return this.type;
    }

    public SQLName getName() {
        return this.name;
    }

    public SQLName getTriggerTarget() {
        return this.triggerTarget;
    }

    public List<TriggerActionType> getAction() {
        return this.action;
    }

    public static enum TriggerActionType {
        INSERT("inserted"),
        DELETE("deleted"),
        UPDATE("inserted", "deleted");

        private final List<String> actionNames = new ArrayList<String>();

        private TriggerActionType(String ... types) {
            for (String type : types) {
                this.actionNames.add(type);
            }
        }

        public List<? extends String> getActionNames() {
            return this.actionNames;
        }
    }

    public static enum TriggerSubType {
        FOR,
        AFTER,
        INSTEAD_OF;

    }

    public static enum TriggerType {
        DDL,
        DML,
        UNKNOWN;

    }
}

