/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule.view;

import com.sigge.filerunner.sql.sqlserver.jobs.schedule.FrequencyType;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.IScheduleBinder;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RecurringSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.DailyOneTimePanel;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.view.DailyRecurringPanel;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.time.LocalDate;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXDatePicker;

public class TypeOfDailyRecurringPanel
extends JPanel
implements IScheduleBinder {
    private SQLServerSchedule schedule;
    private Binder.Presenter<FrequencyType> typeOfDailyBinder;
    private Binder.Presenter<LocalDate> startDatePresenter;
    private Binder.Presenter<LocalDate> endDatePresenter;
    private Binder.Presenter<Boolean> endingActiveBinder;

    public TypeOfDailyRecurringPanel() {
        super(new FlowLayout(0));
        DailyOneTimePanel oneTimePanel = new DailyOneTimePanel();
        DailyRecurringPanel occursEveryBluePanel = new DailyRecurringPanel();
        JPanel typeOfDailyPanel = new JPanel(new BorderLayout());
        JPanel innerTypeOfDailyPanel = new JPanel(new FlowLayout(0));
        typeOfDailyPanel.add((Component)innerTypeOfDailyPanel, "North");
        innerTypeOfDailyPanel.add(new JLabel("Daily schedule:"));
        JComboBox typeOfDaily = new JComboBox();
        innerTypeOfDailyPanel.add(typeOfDaily);
        JXDatePicker dateFrom = new JXDatePicker();
        innerTypeOfDailyPanel.add(new JLabel(" starting at: "));
        innerTypeOfDailyPanel.add((Component)dateFrom);
        this.startDatePresenter = Binder.genericBind((Object)dateFrom, (ap, prop) -> ap.bind(dateFrom).to(prop), (Object)LocalDate.now()).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().setStartDate((LocalDate)v);
            }
        }, true);
        JCheckBox endingActive = new JCheckBox("ending: ");
        innerTypeOfDailyPanel.add(endingActive);
        JXDatePicker dateTo = new JXDatePicker();
        innerTypeOfDailyPanel.add((Component)dateTo);
        this.endDatePresenter = Binder.genericBind((Object)dateTo, (ap, prop) -> ap.bind(dateTo).to(prop), (Object)LocalDate.now()).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().setEndDate((LocalDate)v);
            }
        }, true);
        this.endingActiveBinder = Binder.genericBind((Object)endingActive, (ap, prop) -> ap.bind((AbstractButton)endingActive).to(prop), (Object)false).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().setEnding((boolean)v);
            }
            dateTo.setEnabled(v.booleanValue());
        }, true);
        JPanel oneDailyChoice = new JPanel();
        typeOfDailyPanel.add((Component)oneDailyChoice, "West");
        this.add(typeOfDailyPanel);
        this.typeOfDailyBinder = Binder.bindToCombo(typeOfDaily, Arrays.asList(FrequencyType.EVERY_NTH, FrequencyType.ONE_TIME)).addValueChangedListener(f -> {
            oneDailyChoice.removeAll();
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().setDailySubType((FrequencyType)((Object)f));
            }
            switch (f) {
                case ONE_TIME: {
                    oneDailyChoice.add(oneTimePanel);
                    oneTimePanel.bind(this.schedule);
                    break;
                }
                case EVERY_NTH: {
                    oneDailyChoice.add(occursEveryBluePanel);
                    occursEveryBluePanel.bind(this.schedule);
                    break;
                }
            }
            oneDailyChoice.revalidate();
            oneDailyChoice.repaint();
        }, true);
    }

    @Override
    public void bind(SQLServerSchedule initial) {
        this.schedule = initial;
        if (this.schedule == null) {
            return;
        }
        RecurringSchedule recurringSchedule = initial.getRecurringSchedule();
        if (recurringSchedule.getDailySubType() == null) {
            recurringSchedule.setDailySubType(FrequencyType.EVERY_NTH);
        }
        this.typeOfDailyBinder.setObject((Object)new ValueHolder((Object)recurringSchedule.getDailySubType()));
        this.endingActiveBinder.setObject((Object)new ValueHolder((Object)recurringSchedule.isEnding()));
        this.startDatePresenter.setObject((Object)new ValueHolder((Object)(recurringSchedule.getStartDate() != null ? recurringSchedule.getStartDate() : LocalDate.now())));
        this.endDatePresenter.setObject((Object)new ValueHolder((Object)(recurringSchedule.getEndDate() != null ? recurringSchedule.getEndDate() : LocalDate.now())));
    }
}

