/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.completion.ADBCompletionProvider;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.SQLBuilder;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.SQLScriptBuilder;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerRunner;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobStep;
import com.siggemannen.functional.throwing.ThrowingBiConsumer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class SaveCommand
extends AJobCommand {
    private static final String SAVE_JOB_COMMAND = SaveCommand.readQueryString("sqlserver_job_save.sql");
    private static final String SAVE_JOB_END_COMMAND = SaveCommand.readQueryString("sqlserver_job_end.sql");
    private static final String SAVE_JOBSTEP_ADD_COMMAND = SaveCommand.readQueryString("sqlserver_jobstep_save_add.sql");
    private static final String SAVE_JOBSTEP_UPDATE_COMMAND = SaveCommand.readQueryString("sqlserver_jobstep_save_update.sql");
    private static final String SAVE_JOBSTEP_DELETE_COMMAND = SaveCommand.readQueryString("sqlserver_jobstep_save_delete.sql");
    private static final String SAVE_JOBSTEP_NAME_UPDATE_COMMAND = SaveCommand.readQueryString("sqlserver_jobstep_name_remap.sql");
    private static final String SCHEDULE_START = SaveCommand.readQueryString("sqlserver_schedule_start.sql");
    private static final String SCHEDULE_END = SaveCommand.readQueryString("sqlserver_schedule_end.sql");
    private static final String SCHEDULE_ADD = SaveCommand.readQueryString("sqlserver_schedule_add.sql");
    private static final String SCHEDULE_UPDATE = SaveCommand.readQueryString("sqlserver_schedule_update.sql");
    private static final String SCHEDULE_DETACH = SaveCommand.readQueryString("sqlserver_schedule_detach.sql");
    private static final String SCHEDULE_ATTACH = SaveCommand.readQueryString("sqlserver_schedule_attach.sql");

    public ICommandResult<IJobObject> execute(Database serverDatabase, IJobObject objects) {
        return this.execute(serverDatabase, Arrays.asList(objects));
    }

    public ICommandResult<IJobObject> execute(Database serverDatabase, List<IJobObject> objects) {
        CommandResult result = new CommandResult();
        for (IJobObject job : objects) {
            SQLServerSchedule schedule;
            SQLServerRunner runner;
            ADBCompletionProvider.Wrapee w22;
            Object step;
            SQLServerJob sqlServerJob = (SQLServerJob)job;
            SQLBuilder sb = new SQLBuilder();
            sb.append(SAVE_JOB_COMMAND);
            HashMap<Integer, Integer> stepReMap = new HashMap<Integer, Integer>();
            HashMap<ADBCompletionProvider.Wrapee, Integer> uniqueStepsWhichNeedsRename = new HashMap<ADBCompletionProvider.Wrapee, Integer>();
            int maxStepId = 0;
            int maxStepIdOld = 0;
            int round = 0;
            while (round < 2) {
                int i = 0;
                while (i < sqlServerJob.getSteps().size()) {
                    step = (SQLServerJobStep)sqlServerJob.getSteps().get(i);
                    if (round == 0) {
                        if (((SQLServerJobStep)step).getStepNumber() != i + 1) {
                            stepReMap.put(((SQLServerJobStep)step).getStepNumber(), i + 1);
                            ((SQLServerJobStep)step).setStepNumber(i + 1);
                        }
                        maxStepId = Math.max(maxStepId, ((SQLServerJobStep)step).getStepNumber());
                        maxStepIdOld = Math.max(maxStepIdOld, ((SQLServerJobStep)step).getStepNumberOriginal());
                        w22 = new ADBCompletionProvider.Wrapee(StringUtils.isBlank(((SQLServerJobStep)step).getStepNameOriginal(), ((SQLServerJobStep)step).getStepName()));
                        Integer ix = (Integer)uniqueStepsWhichNeedsRename.get(w22);
                        int stepMax = Math.max(((SQLServerJobStep)step).getStepNumber(), ((SQLServerJobStep)step).getStepNumberOriginal());
                        if (ix == null || ix < stepMax) {
                            uniqueStepsWhichNeedsRename.put(w22, stepMax);
                        }
                    } else {
                        Integer to;
                        StepAction onFailure = ((SQLServerJobStep)step).getOnFailure();
                        StepAction onSuccess = ((SQLServerJobStep)step).getOnSuccess();
                        if (onFailure.getType() == StepAction.ActionType.GO_TO_STEP_X && (to = (Integer)stepReMap.get(onFailure.getStepTo())) != null) {
                            onFailure.setStepTo(to);
                        }
                        if (onSuccess.getType() == StepAction.ActionType.GO_TO_STEP_X && (to = (Integer)stepReMap.get(onSuccess.getStepTo())) != null) {
                            onSuccess.setStepTo(to);
                        }
                    }
                    ++i;
                }
                ++round;
            }
            for (SQLServerJobStep step2 : sqlServerJob.getJobStepsRemoved()) {
                ADBCompletionProvider.Wrapee w;
                Integer ix;
                maxStepIdOld = Math.max(maxStepIdOld, step2.getStepNumberOriginal());
                if (step2.getStepNumber() <= maxStepId || (ix = (Integer)uniqueStepsWhichNeedsRename.get(w = new ADBCompletionProvider.Wrapee(step2.getStepNameOriginal()))) != null && ix >= step2.getNumber() - 1) continue;
                uniqueStepsWhichNeedsRename.put(w, step2.getNumber());
            }
            int i = 1;
            while (i <= Math.max(maxStepId, maxStepIdOld)) {
                if (i > maxStepId) {
                    sb.append(SAVE_JOBSTEP_DELETE_COMMAND);
                } else if (i > maxStepIdOld) {
                    sb.append(SAVE_JOBSTEP_ADD_COMMAND);
                } else {
                    sb.append(SAVE_JOBSTEP_UPDATE_COMMAND);
                }
                ++i;
            }
            for (IJobStep jstep : sqlServerJob.getSteps()) {
                step = (SQLServerJobStep)jstep;
                w22 = new ADBCompletionProvider.Wrapee(((SQLServerJobStep)step).getStepName());
                Integer stepIdWithMatchingName = (Integer)uniqueStepsWhichNeedsRename.get(w22);
                if (stepIdWithMatchingName == null || stepIdWithMatchingName <= ((SQLServerJobStep)step).getStepNumber()) continue;
                sb.append(SAVE_JOBSTEP_NAME_UPDATE_COMMAND);
            }
            if (stepReMap.containsKey(sqlServerJob.getStartStepId())) {
                sqlServerJob.setStartStepId((Integer)stepReMap.get(sqlServerJob.getStartStepId()));
            }
            sb.append(SAVE_JOB_END_COMMAND);
            int maxStepId2 = maxStepId;
            int maxStepIdOld2 = maxStepIdOld;
            try {
                step = null;
                w22 = null;
                try {
                    runner = new SQLServerRunner(new ServerDatabase(serverDatabase, "msdb"), sb.build());
                    try {
                        SQLOptions options = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).prepareStatement((ThrowingBiConsumer<Integer, PreparedStatement>)((ThrowingBiConsumer)(statementId, ps) -> {
                            int param = 1;
                            ps.setString(param++, sqlServerJob.getNativeId());
                            ps.setInt(param++, sqlServerJob.getStartStepId());
                            int i = 0;
                            while (i < 1) {
                                ps.setString(param++, sqlServerJob.getName());
                                ps.setBoolean(param++, sqlServerJob.isEnabled());
                                ++i;
                            }
                            i = 1;
                            while (i <= Math.max(maxStepId2, maxStepIdOld2)) {
                                if (i > maxStepId2) {
                                    param = this.setStepParameter(sqlServerJob, (PreparedStatement)ps, param, maxStepIdOld2 - (i - maxStepId2 - 1), null, true, false);
                                } else {
                                    SQLServerJobStep step = (SQLServerJobStep)sqlServerJob.getSteps().get(i - 1);
                                    step.normalize();
                                    ADBCompletionProvider.Wrapee w = new ADBCompletionProvider.Wrapee(step.getStepName());
                                    Integer stepIdWithMatchingName = (Integer)uniqueStepsWhichNeedsRename.get(w);
                                    param = this.setStepParameter(sqlServerJob, (PreparedStatement)ps, param, i, step, false, stepIdWithMatchingName != null && stepIdWithMatchingName > step.getStepNumber());
                                }
                                ++i;
                            }
                            for (IJobStep jstep : sqlServerJob.getSteps()) {
                                SQLServerJobStep step = (SQLServerJobStep)jstep;
                                ADBCompletionProvider.Wrapee w = new ADBCompletionProvider.Wrapee(step.getStepName());
                                Integer stepIdWithMatchingName = (Integer)uniqueStepsWhichNeedsRename.get(w);
                                if (stepIdWithMatchingName == null || stepIdWithMatchingName <= step.getStepNumber()) continue;
                                ps.setInt(param++, step.getStepNumber());
                                ps.setString(param++, step.getStepName());
                            }
                            ps.setString(param++, sqlServerJob.getName());
                            ps.setBoolean(param++, sqlServerJob.isEnabled());
                        })).build();
                        runner.runQuery((rs, count) -> {
                            try {
                                if (rs.next()) {
                                    String jobUID = rs.getString("jobId");
                                    int returnValue = rs.getInt("retval");
                                    if (rs.wasNull()) {
                                        result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                                    } else if (returnValue != 0) {
                                        result.addFailureResult(job, "Job save failed with error code:" + returnValue, null);
                                    } else {
                                        sqlServerJob.setNativeId(jobUID);
                                        result.addOkResult(job);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                result.addFailureResult(job, "Failed while fetching job save status", ex);
                            }
                        }, ex -> {
                            ex.printStackTrace();
                            result.addFailureResult(job, "Failed while executing job save", (Exception)ex);
                        }, options);
                    }
                    finally {
                        if (runner != null) {
                            runner.close();
                        }
                    }
                }
                catch (Throwable w22) {
                    if (step == null) {
                        step = w22;
                    } else if (step != w22) {
                        ((Throwable)step).addSuppressed(w22);
                    }
                    throw step;
                }
            }
            catch (Exception ex2) {
                result.addFailureResult(job, "Failed while setting up job runner", ex2);
            }
            sb = new SQLBuilder();
            if (sqlServerJob.getSchedules().size() <= 0 && sqlServerJob.getSchedules_removed().size() <= 0) continue;
            sb.append(SCHEDULE_START);
            int i2 = 0;
            while (i2 < sqlServerJob.getSchedules().size()) {
                schedule = (SQLServerSchedule)sqlServerJob.getSchedules().get(i2);
                this.setScheduleParameters(sb, sqlServerJob, schedule);
                sb.append(new SQLScriptBuilder(SCHEDULE_ATTACH).addRaw("@schedule_job_id").addRaw("@schedule_id").build());
                ++i2;
            }
            i2 = 0;
            while (i2 < sqlServerJob.getSchedules_removed().size()) {
                schedule = sqlServerJob.getSchedules_removed().get(i2);
                sb.append(new SQLScriptBuilder(SCHEDULE_DETACH).add(sqlServerJob.getNativeId()).add(schedule.getScheduleId()).build());
                ++i2;
            }
            sb.append(SCHEDULE_END);
            try {
                Throwable i3 = null;
                Object var15_25 = null;
                try {
                    runner = new SQLServerRunner(new ServerDatabase(serverDatabase, "msdb"), sb.build());
                    try {
                        SQLOptions options = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).build();
                        runner.runQuery((rs, count) -> {
                            try {
                                if (rs.next()) {
                                    int returnValue = rs.getInt("retval");
                                    if (rs.wasNull()) {
                                        result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                                    } else if (returnValue != 0) {
                                        result.addFailureResult(job, "Job save failed with error code:" + returnValue, null);
                                    } else {
                                        result.addOkResult(job);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                result.addFailureResult(job, "Failed while fetching job schedule status", ex);
                            }
                        }, ex -> {
                            ex.printStackTrace();
                            result.addFailureResult(job, "Failed while executing job schedule save", (Exception)ex);
                        }, options);
                    }
                    finally {
                        if (runner != null) {
                            runner.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (i3 == null) {
                        i3 = throwable;
                    } else if (i3 != throwable) {
                        i3.addSuppressed(throwable);
                    }
                    throw i3;
                }
            }
            catch (Exception ex3) {
                result.addFailureResult(job, "Failed while setting up job schedule runner", ex3);
            }
        }
        return result;
    }

    private void setScheduleParameters(SQLBuilder sb, SQLServerJob sqlServerJob, SQLServerSchedule schedule) {
        SQLScriptBuilder builder = new SQLScriptBuilder(schedule.getScheduleGUID() != null ? SCHEDULE_UPDATE : SCHEDULE_ADD);
        builder.add(sqlServerJob.getNativeId()).add(schedule.getScheduleGUID() == null ? null : Integer.valueOf(schedule.getScheduleId())).add(schedule.getScheduleName()).add(schedule.isEnabled());
        SQLServerSchedule.ScheduleToSQL sql_values = schedule.getSQLValues();
        builder.add(sql_values.freq_type).add(sql_values.freq_interval).add(sql_values.freq_subday_type).add(sql_values.freq_subday_interval).add(sql_values.freq_relative_interval).add(sql_values.freq_recurrence_factor).add(sql_values.active_start_date).add(sql_values.active_end_date).add(sql_values.active_start_time).add(sql_values.active_end_time);
        sb.append(builder.build());
    }

    private int setStepParameter(SQLServerJob sqlServerJob, PreparedStatement ps, int param, int stepId, SQLServerJobStep step, boolean deleted, boolean useUniqueName) throws SQLException {
        ps.setInt(param++, stepId);
        if (deleted) {
            return param;
        }
        int i = 0;
        while (i < 1) {
            ps.setString(param++, useUniqueName ? UUID.randomUUID().toString() : step.getStepName());
            ps.setInt(param++, step.getOnSuccess().getType().getType());
            ps.setInt(param++, step.getOnSuccess().getStepTo());
            ps.setInt(param++, step.getOnFailure().getType().getType());
            ps.setInt(param++, step.getOnFailure().getStepTo());
            ps.setInt(param++, step.getRetryAttempts());
            ps.setInt(param++, step.getRetryInterval());
            ps.setString(param++, step.getSubsystem().getName());
            ps.setString(param++, step.getCommand());
            ps.setInt(param++, step.getFlags());
            ps.setString(param++, step.getDatabase());
            ps.setString(param++, step.getUserName());
            ps.setString(param++, step.getOutputFileName());
            ++i;
        }
        return param;
    }
}

