/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs;

import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResultDetail;
import com.sigge.filerunner.view.jobs.IJobObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;

public class CommandResultDetail
implements ICommandResultDetail<IJobObject> {
    private final IJobObject object;
    private String message;
    private Optional<Exception> exception;
    private boolean success;

    public static CommandResultDetail success(IJobObject object) {
        CommandResultDetail c = new CommandResultDetail(object);
        c.success = true;
        c.exception = Optional.empty();
        return c;
    }

    public static CommandResultDetail success(IJobObject object, String message) {
        CommandResultDetail c = new CommandResultDetail(object);
        c.message = message;
        c.success = true;
        c.exception = Optional.empty();
        return c;
    }

    public static CommandResultDetail failure(IJobObject object, String message, Optional<Exception> exception) {
        CommandResultDetail c = new CommandResultDetail(object);
        c.message = message;
        c.exception = exception;
        c.success = false;
        return c;
    }

    private CommandResultDetail(IJobObject object) {
        this.object = object;
    }

    @Override
    public IJobObject getObject() {
        return this.object;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<Exception> getException() {
        return this.exception;
    }

    @Override
    public boolean isOK() {
        return this.success;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        if (this.exception.isPresent()) {
            this.exception.get().printStackTrace(new PrintWriter(sw));
        }
        return "Job: " + this.object + ", message: " + this.message + ", success: " + this.success + ",exception:" + this.exception + sw.toString();
    }
}

