/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs;

import com.sigge.filerunner.sql.sqlserver.jobs.CommandResultDetail;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResultDetail;
import com.sigge.filerunner.view.jobs.IJobObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CommandResult
implements ICommandResult<IJobObject> {
    private boolean successResult;
    private boolean cancelled;
    private boolean queued;
    private final List<ICommandResultDetail<IJobObject>> details = new ArrayList<ICommandResultDetail<IJobObject>>();

    public CommandResult() {
        this.successResult = true;
    }

    public static CommandResult cancelled() {
        CommandResult result = new CommandResult();
        result.cancelled = true;
        result.successResult = false;
        return result;
    }

    public static CommandResult queued() {
        CommandResult result = new CommandResult();
        result.cancelled = false;
        result.successResult = false;
        result.queued = true;
        return result;
    }

    public CommandResult(List<IJobObject> objects, String message) {
        this.successResult = false;
        CommandResult result = new CommandResult();
        for (IJobObject object : objects) {
            result.addFailureResult(object, message, null);
        }
    }

    @Override
    public boolean isOK() {
        return this.successResult;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public List<ICommandResultDetail<IJobObject>> getDetails() {
        return this.details;
    }

    public CommandResult addOkResult(IJobObject object) {
        this.details.add(CommandResultDetail.success(object));
        return this;
    }

    public CommandResult addOkResult(IJobObject object, String message) {
        this.details.add(CommandResultDetail.success(object, message));
        return this;
    }

    public CommandResult addFailureResult(IJobObject object, String message, Exception ex) {
        this.successResult = false;
        this.details.add(CommandResultDetail.failure(object, message, Optional.ofNullable(ex)));
        return this;
    }

    public String toString() {
        return "CommandResult [" + ", success:" + this.successResult + ", details: " + this.details + "]";
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        this.queued = queued;
    }
}

