/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.sql.edit.IParseResult;
import com.sigge.filerunner.view.IEditorResource;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

@Singleton
public class TSQLFoldParser
implements FoldParser,
IEditorResource {
    private final WeakHashMap<RSyntaxTextArea, FutureFold2> JOB_MAP = new WeakHashMap();
    private IEditor parser;

    @Inject
    public TSQLFoldParser() {
    }

    @Inject
    public void setEditor(IEditor parser) {
        this.parser = parser;
    }

    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        if (textArea.getDocument().getDefaultRootElement().getElementCount() <= 2) {
            return Collections.EMPTY_LIST;
        }
        FutureFold2 fold = this.JOB_MAP.computeIfAbsent(textArea, f -> new FutureFold2(textArea));
        if (fold.finished) {
            return this.returnFolds(fold);
        }
        IParseResult res = this.parser.parse(textArea);
        if (res == null) {
            fold.finished = false;
            return Collections.EMPTY_LIST;
        }
        Optional<List<Fold>> optFold = res.getFolds((ThrowingConsumer<List<Fold>>)((ThrowingConsumer)f -> this.mutateFold(fold, (List<Fold>)f, textArea)));
        if (optFold.isPresent()) {
            this.mutateFold(fold, optFold.get(), textArea);
            return this.returnFolds(fold);
        }
        if (fold.prevFolds != null) {
            return fold.prevFolds;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Fold> returnFolds(FutureFold2 fold) {
        if (fold.prevFolds != null) {
            if (fold.folds == null) {
                return fold.prevFolds;
            }
            fold.prevFolds = fold.folds;
            return fold.folds;
        }
        fold.prevFolds = fold.folds;
        return fold.folds;
    }

    private void mutateFold(FutureFold2 ff, List<Fold> f, RSyntaxTextArea textArea) {
        ff.finished = true;
        ff.folds = f;
        SwingUtilities.invokeLater(() -> ((FoldManager)textArea.getFoldManager()).reparse());
    }

    @Override
    public void close(RSyntaxTextArea textArea) {
        FutureFold2 x = this.JOB_MAP.remove(textArea);
        if (x != null) {
            textArea.getDocument().removeDocumentListener(x.da);
        }
    }

    private int foldCount(List<Fold> f) {
        int cnt = 0;
        for (Fold fold : f) {
            cnt += this.foldCount(fold);
        }
        return cnt;
    }

    private int foldCount(Fold f) {
        int count = 0;
        for (int i = 0; i < f.getChildCount(); ++i) {
            Fold ff = f.getChild(i);
            count += this.foldCount(ff);
            count += f.getChildCount();
        }
        return count;
    }

    private class FutureFold2 {
        List<Fold> prevFolds;
        List<Fold> folds;
        boolean finished;
        DocumentListener da = new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                FutureFold2.this.finished = false;
            }
        };

        FutureFold2(RSyntaxTextArea ra) {
            ra.getDocument().addDocumentListener(this.da);
        }
    }
}

