/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.FunctionDocX;
import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.IServerConfigHandler;
import com.sigge.filerunner.completion.domain.IUsageObject;
import com.sigge.filerunner.completion.domain.ParamReplacement;
import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.completion.domain.SubObjectType;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.ADatabaseContext;
import com.sigge.filerunner.sql.SQLBuilder;
import com.sigge.filerunner.sql.SQLOperation;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.BasicSQLTokenizer;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.ContextUtils;
import com.sigge.filerunner.sql.sqlserver.CreateOrDeclareTableVisitor;
import com.sigge.filerunner.sql.sqlserver.CreateTable;
import com.sigge.filerunner.sql.sqlserver.FlagsEncoder;
import com.sigge.filerunner.sql.sqlserver.Proc;
import com.sigge.filerunner.sql.sqlserver.ProcInformation;
import com.sigge.filerunner.sql.sqlserver.SQLServerColumn;
import com.sigge.filerunner.sql.sqlserver.SQLServerName;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.sqlserver.parser.Procedure;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.Scope;
import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.TokenType;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.core.Tuple;
import com.siggemannen.sql.antler.CaseChangingCharStreamUpper;
import com.siggemannen.sql.antler.TSqlLexer;
import com.siggemannen.sql.antler.TSqlParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerDatabaseContext
extends ADatabaseContext {
    private static final HashSet<String> DEFAULT_DATA_TYPES = new HashSet<String>(Arrays.asList("BIGINT", "BINARY", "BIT", "CHAR", "DATE", "DATETIME", "DATETIME2", "DATETIMEOFFSET", "DECIMAL", "FLOAT", "GEOGRAPHY", "GEOMETRY", "HIERARCHYID", "IMAGE", "INT", "MONEY", "NCHAR", "NTEXT", "NUMERIC", "NVARCHAR", "REAL", "ROWVERSION", "SMALLDATETIME", "SMALLINT", "SMALLMONEY", "SQL_VARIANT", "SYSNAME", "TEXT", "TIME", "TIMESTAMP", "TINYINT", "UNIQUEIDENTIFIER", "VARBINARY", "VARCHAR", "XML"));
    private static final DateTimeFormatter TIME_SECOND = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 3, true).toFormatter();
    private static final DateTimeFormatter SIMPLE_DATE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(TIME_SECOND).toFormatter();
    static final String CELLS_PER_OBJECT = "cells_per_object";
    static final String LEVEL_4_GRID_DESC = "level_4_grid_desc";
    static final String LEVEL_3_GRID_DESC = "level_3_grid_desc";
    static final String LEVEL_2_GRID_DESC = "level_2_grid_desc";
    static final String LEVEL_1_GRID_DESC = "level_1_grid_desc";
    static final String BOUNDING_BOX_YMAX = "bounding_box_ymax";
    static final String BOUNDING_BOX_XMAX = "bounding_box_xmax";
    static final String BOUNDING_BOX_YMIN = "bounding_box_ymin";
    static final String BOUNDING_BOX_XMIN = "bounding_box_xmin";
    static final String SPATIAL_SCHEME = "scheme";
    static final String SPATIAL_INDEX_TYPE = "spatial_type";
    static final int SPATIAL_TYPE = 4;
    private static final String KEY_ORDINAL_PROP = "key_ordinal";
    static final String PARTITION_ORDINAL_PROP = "partition_ordinal";
    public static final String DESCENDING_PROP = "descending";
    public static final String PARTITION_COLUMNS_PROP = "partitionColumns";
    private static final String PARTITION_FUNCTION_PROP = "partitionFunction";
    public static final String PARTITION_SCHEME_PROP = "partitionScheme";
    private static final String F_GROUP_PROP = "fGroup";
    static final String COMPRESSION_PROP = "compression";
    public static final String FILTER_PROP = "filter";
    static final String ALLOW_PAGE_LOCKS_PROP = "allowPageLocks";
    static final String ALLOW_ROW_LOCKS_PROP = "allowRowLocks";
    static final String DISABLED_PROP = "disabled";
    static final String PADDED_PROP = "padded";
    static final String FILL_FACTOR_PROP = "fillFactor";
    public static final String SYNONYM_NAME = "SYNONYM_NAME";
    private static final String UNIQUE_CONSTRAINT_PROP = "uniqueConstraint";
    static final String IGNORE_DUP_PROP = "ignore_dup";
    private static final String TYPE_PROP = "type";
    private static final String INDEX_ID_PROP = "index_id";
    public static final String NILADIC = "niladic";
    static final String COLUMN_COLLATION = "COLUMN_COLLATION";
    static final String COLUMN_CONSTRAINT = "COLUMN_CONSTRAINT";
    static final String COLUMNTYPE_NAME_PROPERTY = "COLUMNTYPE_NAME";
    static final String COLUMNTYPE_PROPERTY = "COLUMNTYPE";
    public static final String COLUMN_ID_PROPERTY = "column_id";
    public static final String PARAMETER_OPTIONAL = "PARAMETER_OPTIONAL";
    public static final String PARAMETER_VARARG = "PARAMETER_VARARG";
    static final Map<String, String> cacheTypesAndSubTypes = new ConcurrentHashMap<String, String>(1000);
    private static final String TABLE_TYPE = "U";
    private static final String SYSTEM_TABLE_TYPE = "S";
    private static final String TABLE_FUNCTION_IF = "IF";
    private static final String TABLE_FUNCTION_TF = "TF";
    private static final String SCALAR_FUNCTION_FN = "FN";
    private static final String PROCEDURE_TYPE = "P";
    private static final String CLR_PROCEDURE_TYPE = "PC";
    private static final String EXTENDED_PROCEDURE_TYPE = "X";
    private static final String TABLE_TYPE_TYPE = "TT";
    private static final String VIEW_TYPE = "V";
    public static final String WINDOW = "window";
    public static final String DOC = "doc";
    static final String SUBOBJECT_TYPE = "SUBOBJECT_TYPE";
    private static final Map<String, SQLObjectType> TYPE_MAP = SQLServerDatabaseContext.createTypeMap();
    private final Set<String> BUILT_IN_TYPES = new HashSet<String>(DEFAULT_DATA_TYPES);
    private SQLOptions options = this.createOptions();
    private int major = 0;
    private int spLevel = 0;
    private String defaultSchema;
    private String defaultCollation = null;
    private static final String metadata = SQLServerDatabaseContext.readQueryString("meta.query");
    private static final String object = SQLServerDatabaseContext.readQueryString("objects.query");
    private static final String storage = SQLServerDatabaseContext.readQueryString("storage.query");
    private static final String buildin = SQLServerDatabaseContext.readQueryString("buildin.query");
    private static final String defaults = SQLServerDatabaseContext.readQueryString("defaults.query");
    private static final Set<String> dbos = SQLServerDatabaseContext.readDbos();
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(SQLServerDatabaseContext.class);
    private Map<Integer, SQLObject> objectMap = new HashMap<Integer, SQLObject>();
    private final Map<Integer, Map<String, String>> OBJECT_DEFAULTS = new HashMap<Integer, Map<String, String>>();
    private final Map<String, SQLObjectUsage> USAGES;
    private final List<SQLObject> buildIns = new ArrayList<SQLObject>();
    private static Map<String, FunctionDocX> FUNCTION_DOCS = SQLServerDatabaseContext.createDocs();
    private final IServerConfigHandler config;
    private Map<String, List<SQLObject>> cache = new HashMap<String, List<SQLObject>>();
    private Map<Integer, List<SQLObject>> speculativeObjects = new HashMap<Integer, List<SQLObject>>();
    private Map<Integer, SQLObject> newlyLoadedObjects = new HashMap<Integer, SQLObject>();
    private int loadCount = 0;
    private boolean lastLoadSucceeded = false;
    private String lastDate = null;
    private String lastDateForObjects = null;

    private SQLOptions createOptions() {
        return new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).timeout(240).build();
    }

    private static Set<String> readDbos() {
        String s = SQLServerDatabaseContext.readQueryString("dboobjects.data");
        return new HashSet<String>(Arrays.asList(s.split("@")));
    }

    private static Map<String, FunctionDocX> createDocs() {
        HashMap<String, FunctionDocX> docmap = new HashMap<String, FunctionDocX>();
        Gson gs = GsonFactory.forReading();
        List docs = (List)gs.fromJson((Reader)new InputStreamReader(DBCompletion.class.getResourceAsStream("docs.json")), new TypeToken<List<FunctionDocX>>(){}.getType());
        for (FunctionDocX func : docs) {
            docmap.put(func.getName(), func);
        }
        return docmap;
    }

    public static Set<String> getDefaultTypeSet() {
        return DEFAULT_DATA_TYPES;
    }

    public SQLServerDatabaseContext(ServerDatabase sb, IServerConfigHandler config) {
        super(sb);
        this.config = config;
        this.USAGES = config.getUsages(this, Optional.empty());
        this.lastFuture = this.es.scheduleWithFixedDelay((Runnable)((Object)new SQLOperation(this::initContext)), 0L, 5L, TimeUnit.MINUTES);
    }

    private static String readQueryString(String string) {
        try {
            return FileUtils.streamContents(SQLServerDatabaseContext.class.getResourceAsStream(string), "UTF8");
        }
        catch (Exception e) {
            DB_LOGGER.error("Error while loading:" + string, (Throwable)e);
            return "";
        }
    }

    @Override
    public boolean isSameIdentifier(String name, SQLObject object) {
        String schema2;
        String schema1;
        SQLServerName sn = new SQLServerName(name);
        String objName = object.getFullName() != null ? object.getFullName() : object.getName();
        SQLServerName sn2 = new SQLServerName(objName);
        if (!this.isSameIdentifier(sn.getName(), sn2.getName())) {
            return false;
        }
        String string = sn.getSchema().length() > 0 ? sn.getSchema() : (schema1 = this.defaultSchema != null ? this.defaultSchema : "");
        String string2 = sn2.getSchema().length() > 0 ? sn2.getSchema() : (schema2 = this.defaultSchema != null ? this.defaultSchema : "");
        if (!this.isSameIdentifier(schema1, schema2)) {
            return false;
        }
        return sn.getDatabase().length() <= 0 || this.isSameIdentifier(sn.getDatabase(), StringUtils.isBlank(object.getContextDatabase(), this.sb.getDatabase()));
    }

    @Override
    protected boolean logException(Exception e, String command, boolean exceptionDuringScriptExecution) {
        if (SQLServerDatabaseContext.isTransientError(e)) {
            return false;
        }
        if (e instanceof SQLTimeoutException) {
            return false;
        }
        if (!exceptionDuringScriptExecution) {
            return true;
        }
        return true;
    }

    public static boolean isTransientError(Exception e) {
        String message = e.getMessage();
        if (e instanceof SQLTimeoutException) {
            return true;
        }
        return e instanceof SQLServerException && (message.matches(".*Cannot open database .* requested by the login\\. The login failed.*") || message.matches(".*Cannot continue the execution because the session is in the kill state.*") || message.matches(".*connect timed out.*") || message.matches(".*The connection is closed.*") || message.matches(".*Time-out occurred.*") || message.matches(".*Read timed out.*") || message.matches(".*The query has timed out.*") || message.matches(".*No route to host.*") || message.matches(".*Connection reset.*") || message.matches(".*TCP/IP.*") || message.matches(".*Done status 3.*"));
    }

    @Override
    public void initContext() throws SQLException, Exception {
        this.newlyLoadedObjects.clear();
        if (metadata != null) {
            boolean incrLoad;
            boolean bl = incrLoad = this.lastLoadSucceeded && this.lastDateForObjects != null && this.loadCount % 4 != 0;
            String objectLoad = incrLoad ? (this.major > 8 ? object.replace("[PLACEHOLDER]", "AND so.modify_date >= ''''" + this.lastDateForObjects + "''''") : object.replace("[PLACEHOLDER]", "AND so.refdate >= ''" + this.lastDateForObjects + "''")) : object.replace("[PLACEHOLDER]", "");
            String capturedLastDateCopy = this.lastDateForObjects;
            this.options = this.createOptions();
            this.runSQL(new SQLBuilder(metadata).append(objectLoad).appendIf(this.buildIns.size() == 0, () -> buildin).build(), (rr, res) -> this.processObjectsInternal(rr, res, incrLoad, capturedLastDateCopy), this.options);
        }
    }

    @Override
    public String getSelectQuery(SQLObject so, int rowNumber) {
        return "SELECT\tTOP " + rowNumber + " *" + System.lineSeparator() + "FROM\t" + so.getContext().getQuotedName(so);
    }

    private void processObjectsInternal(ResultSet r, int resultSets, boolean increment, String lastDateForObjectsToUse) throws SQLException {
        String name;
        if (resultSets == 1) {
            r.next();
            this.defaultCollation = r.getString("collation");
            String version = r.getString("productversion");
            this.defaultSchema = r.getString("defaultUserSchema");
            Timestamp dt = r.getTimestamp("dt");
            this.lastDateForObjects = SIMPLE_DATE_FORMAT.format(dt.toLocalDateTime());
            String[] v = version.split("\\.");
            if (v.length < 3) {
                return;
            }
            this.major = Integer.valueOf(v[0]);
            this.spLevel = Integer.valueOf(v[2]);
            r.close();
        } else if (resultSets == 2) {
            ArrayList<SQLObject> schemas = new ArrayList<SQLObject>();
            while (r.next()) {
                Integer schema_id = r.getInt("schema_id");
                name = r.getString("name");
                schemas.add(new SQLObject(this, schema_id, name, "SCHEMA", SQLObjectType.SCHEMA, name, false));
            }
            this.schemas = schemas;
            r.close();
        } else if (resultSets == 3) {
            ArrayList<SQLObject> databases = new ArrayList<SQLObject>();
            while (r.next()) {
                int db_id = r.getInt("database_id");
                name = r.getString("name");
                databases.add(new SQLObject(this, db_id, name, "DATABASE", SQLObjectType.DATABASE, "", db_id < 5));
            }
            r.close();
            this.databases = databases;
        }
        if (resultSets == 4) {
            int prev_object_id = 0;
            String colType = null;
            SQLObject object = null;
            Integer param = 0;
            ArrayList<Object> objects = increment ? new ArrayList() : new ArrayList<SQLObject>(this.buildIns);
            HashMap<Integer, SQLObject> objectMap = new HashMap<Integer, SQLObject>(4000, 0.9f);
            Map<String, String> defaults = null;
            while (r.next()) {
                SQLObjectUsage usage;
                String collation;
                int object_id = r.getInt("object_id");
                String colname = r.getString("colname");
                if (colname != null && colname.length() < 10) {
                    colname = cacheTypesAndSubTypes.computeIfAbsent(colname, k -> k);
                }
                param = r.getInt("param");
                String typeName = r.getString("typename");
                colType = r.getString("coltype");
                Integer column_id = r.getInt(COLUMN_ID_PROPERTY);
                Boolean identity = r.getInt("is_identity") == 1;
                Boolean nullable = r.getInt("is_nullable") == 1;
                Boolean is_output = r.getInt("is_output") == 1;
                String constraint = r.getString("constraint_definition");
                String computedDefinition = r.getString("computed_definition");
                Boolean persisted = r.getInt("is_persisted") == 1;
                String string = r.getString("collation_name");
                String string2 = collation = string == null ? null : cacheTypesAndSubTypes.computeIfAbsent(string, k -> k);
                if (prev_object_id != object_id) {
                    String obj_type_native;
                    if (object != null) {
                        object.finish();
                    }
                    if ((obj_type_native = r.getString("obj_type")) != null) {
                        obj_type_native = cacheTypesAndSubTypes.computeIfAbsent(obj_type_native, k -> k);
                    }
                    object = new SQLObject(this, object_id, r.getString("name"), obj_type_native, SQLServerDatabaseContext.fromString(obj_type_native), cacheTypesAndSubTypes.computeIfAbsent(r.getString("schema_name"), k -> k), r.getBoolean("systemObject"));
                    objects.add(object);
                    prev_object_id = object_id;
                    objectMap.put(object_id, object);
                    defaults = this.OBJECT_DEFAULTS.get(object_id);
                    usage = this.USAGES.get(String.valueOf(object_id));
                    if (usage != null) {
                        object.setUsage(usage);
                    }
                }
                int sizeflags = 0;
                int columnFlags = FlagsEncoder.encode(column_id, colType != null ? colType.length() : 0, nullable, identity, persisted, is_output);
                if (param == 2) {
                    object.setReturnType(cacheTypesAndSubTypes.computeIfAbsent(typeName + (colType != null ? colType : ""), k -> k));
                    continue;
                }
                SQLServerColumn col = new SQLServerColumn(colname, cacheTypesAndSubTypes.computeIfAbsent(typeName + (colType != null ? colType : ""), k -> k), columnFlags, sizeflags);
                col.setDefaultValue(constraint != null && constraint.length() < 20 ? cacheTypesAndSubTypes.computeIfAbsent(constraint, k -> k) : null);
                col.setComputedDefinition(computedDefinition);
                col.setCollation(collation);
                if (param == 0) {
                    usage = this.USAGES.get(String.valueOf(object_id) + "_" + column_id + "_" + SubObjectType.COLUMN.getType());
                    if (usage != null) {
                        col.setUsage(usage);
                    }
                    object.addColumn(col);
                    continue;
                }
                if (param != 1) continue;
                if (defaults != null) {
                    col.setDefaultValue(defaults.get(colname));
                }
                col.setObjectType(SubObjectType.PARAMETER);
                usage = this.USAGES.get(String.valueOf(object_id) + "_" + column_id + "_" + SubObjectType.PARAMETER.getType());
                if (usage != null) {
                    col.setUsage(usage);
                }
                object.addParameter(col);
            }
            r.close();
            if (increment) {
                if (objects.size() > 0) {
                    for (int i = 0; i < objects.size(); ++i) {
                        SQLObject todo = (SQLObject)objects.get(i);
                        SQLObject existing = this.objectMap.get(todo.getId());
                        if (existing == null) {
                            this.objects.add(todo);
                            this.objectMap.put(todo.getId(), todo);
                            continue;
                        }
                        existing.emplace(todo);
                    }
                    this.cache = new HashMap<String, List<SQLObject>>();
                }
                this.newlyLoadedObjects = objectMap;
            } else {
                this.objects = objects;
                this.cache = new HashMap<String, List<SQLObject>>();
                this.objectMap = objectMap;
                this.newlyLoadedObjects = new HashMap<Integer, SQLObject>();
            }
            this.loadCount = (this.loadCount + 1) % 4;
            this.lastLoadSucceeded = true;
        } else if (resultSets == 5) {
            while (r.next()) {
                String builtin = r.getString("name");
                Integer args = r.getInt("args");
                Integer args_to = r.getInt("args_to");
                if (r.wasNull()) {
                    args_to = null;
                }
                boolean niladic = r.getInt(NILADIC) == 1;
                for (int overloads = 0; overloads <= (args_to == null || args_to > 100 ? 0 : args_to - args); ++overloads) {
                    SQLObject sob = new SQLObject(this, -1, builtin, "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
                    sob.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)niladic).append((Object)WINDOW, (Object)(r.getInt(WINDOW) == 1 ? 1 : 0)).append((Object)DOC, (Object)FUNCTION_DOCS.get(builtin)).build());
                    if (!niladic) {
                        SQLSubObject sub;
                        int i;
                        for (i = 1; i <= args + overloads; ++i) {
                            sub = new SQLSubObject("param" + i, "");
                            sub.setCustomProperties(Collections.EMPTY_MAP);
                            sob.addParameter(sub);
                        }
                        if (args_to != null && args_to > 100) {
                            sub = new SQLSubObject("[param" + i + "[...,paramN]]", "");
                            sub.setCustomProperties(Collections.EMPTY_MAP);
                            sob.addParameter(sub);
                        }
                    }
                    sob.finish();
                    this.buildIns.add(sob);
                }
            }
            SQLObject cast = new SQLObject(this, -1, "CAST", "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
            SQLSubObject sub = new SQLSubObject("value", "");
            cast.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
            HashMap<String, Object> sox = new HashMap<String, Object>();
            sox.put("Extra", new ParamReplacement(" AS type", 4, 7));
            sub.setCustomProperties(sox);
            cast.addParameter(sub);
            SQLSubObject genericValue = new SQLSubObject("value", "");
            SQLObject convert = new SQLObject(this, -1, "CONVERT", "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
            convert.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
            convert.addParameter(new SQLSubObject(TYPE_PROP, ""));
            convert.addParameter(new SQLSubObject("value", ""));
            convert.addParameter(new SQLSubObject("style", "").putCustomProperty(PARAMETER_OPTIONAL, true));
            SQLObject identity = new SQLObject(this, -1, "IDENTITY", "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
            identity.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
            identity.addParameter(new SQLSubObject("data_type", ""));
            identity.addParameter(new SQLSubObject("seed", "INT").putCustomProperty(PARAMETER_OPTIONAL, true));
            identity.addParameter(new SQLSubObject("increment", "INT").putCustomProperty(PARAMETER_OPTIONAL, true));
            this.buildIns.add(identity);
            if (this.major >= 12) {
                SQLObject trycast = new SQLObject(this, -1, "TRY_CAST", "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
                trycast.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
                trycast.addParameter(sub);
                SQLObject try_convert = new SQLObject(this, -1, "TRY_CONVERT", "builtin", SQLObjectType.SCALAR_FUNCTION, "", true, true);
                try_convert.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
                try_convert.addParameter(new SQLSubObject(TYPE_PROP, ""));
                try_convert.addParameter(new SQLSubObject("value", ""));
                try_convert.addParameter(new SQLSubObject("style", "").putCustomProperty(PARAMETER_OPTIONAL, true));
                this.buildIns.add(trycast);
                this.buildIns.add(try_convert);
            }
            if (this.major >= 13) {
                SQLObject string_split = new SQLObject(this, -1, "STRING_SPLIT", "builtin", SQLObjectType.TABLE_FUNCTION, "", true, true);
                string_split.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
                string_split.addParameter(genericValue);
                SQLSubObject separator = new SQLSubObject("separator", "NVARCHAR(1)");
                SQLSubObject valueSplit = new SQLSubObject("value", "NVARCHAR(MAX)");
                string_split.addColumn(valueSplit);
                string_split.addParameter(separator);
                if (this.major >= 16) {
                    SQLSubObject enable_ordinal = new SQLSubObject("enable_ordinal", "INT").putCustomProperty(PARAMETER_OPTIONAL, true);
                    SQLSubObject ordinal = new SQLSubObject("ordinal", "INT");
                    string_split.addParameter(enable_ordinal);
                    string_split.addColumn(ordinal);
                }
                this.buildIns.add(string_split);
                SQLObject openjson = new SQLObject(this, -1, "OPENJSON", "builtin", SQLObjectType.TABLE_FUNCTION, "", true, true);
                openjson.setCustomProperties(new MapBuilder((Object)NILADIC, (Object)false).append((Object)WINDOW, (Object)false).build());
                openjson.addParameter(genericValue);
                SQLSubObject path = new SQLSubObject("path", "NVARCHAR(MAX)").putCustomProperty(PARAMETER_OPTIONAL, true);
                openjson.addParameter(path);
                SQLSubObject key = new SQLSubObject("key", "NVARCHAR(MAX)");
                openjson.addColumn(key);
                SQLSubObject value = new SQLSubObject("value", "NVARCHAR(MAX)");
                openjson.addColumn(value);
                SQLSubObject type = new SQLSubObject(TYPE_PROP, "INT");
                openjson.addColumn(type);
                this.buildIns.add(openjson);
            }
            if (this.major >= 16) {
                SQLObject generate_series = new SQLObject(this, -1, "GENERATE_SERIES", "builtin", SQLObjectType.TABLE_FUNCTION, "", true, true);
                SQLSubObject from = new SQLSubObject("from", "INT");
                SQLSubObject to = new SQLSubObject("to", "INT");
                SQLSubObject step = new SQLSubObject("step", "INT").putCustomProperty(PARAMETER_OPTIONAL, true);
                generate_series.addParameter(from);
                generate_series.addParameter(to);
                generate_series.addParameter(step);
                SQLSubObject value = new SQLSubObject("value", "INT");
                generate_series.addColumn(value);
                this.buildIns.add(generate_series);
            }
            this.buildIns.add(cast);
            this.buildIns.add(convert);
            this.objects.addAll(this.buildIns);
            this.cache = new HashMap<String, List<SQLObject>>();
            r.close();
        }
        if (resultSets == 5 || resultSets == 4 && this.buildIns.size() > 0) {
            try {
                String stRage;
                if (increment) {
                    if (this.newlyLoadedObjects != null && this.newlyLoadedObjects.size() == 0) {
                        return;
                    }
                    stRage = this.major > 8 ? storage.replace("[PLACEHOLDER]", "AND so.modify_date >= ''''" + lastDateForObjectsToUse + "''''") : storage.replace("[PLACEHOLDER]", "AND so.refdate >= ''" + lastDateForObjectsToUse + "''");
                } else {
                    stRage = storage.replace("[PLACEHOLDER]", "");
                }
                this.options = this.createOptions();
                this.runSQL(stRage, (res, rr) -> this.processStorageInternal(res, rr, increment), this.options);
            }
            catch (Exception e) {
                this.LOGGER.error("Error while loading storage", (Throwable)e);
            }
        }
    }

    private void processStorageInternal(ResultSet r, int resultSet, boolean incr) throws SQLException {
        int object_id;
        if (resultSet == 1) {
            SQLObject syn = null;
            String name = null;
            while (r.next()) {
                object_id = r.getInt("object_id");
                name = r.getString("name");
                syn = this.objectMap.get(object_id);
                if (syn == null || syn.getCustomProperties() != null && (!incr || this.newlyLoadedObjects != null && !this.newlyLoadedObjects.containsKey(object_id))) continue;
                Map builder = new MapBuilder((Object)SYNONYM_NAME, (Object)name).build();
                syn.setCustomProperties(builder);
            }
            r.close();
        }
        if (resultSet == 2) {
            SQLObject object = null;
            while (r.next()) {
                object_id = r.getInt("object_id");
                object = this.objectMap.get(object_id);
                if (object == null || incr && (this.newlyLoadedObjects == null || !this.newlyLoadedObjects.containsKey(object_id))) continue;
                String fGroup = r.getString("fileGroupName");
                String name = r.getString("name");
                Integer index_id = r.getInt(INDEX_ID_PROP);
                Integer type = r.getInt(TYPE_PROP);
                Boolean unique = r.getInt("is_unique") == 1;
                Boolean ignore_dup = r.getInt("ignore_dup_key") == 1;
                Boolean primary = r.getInt("is_primary_key") == 1;
                Boolean uniqueConstraint = r.getInt("is_unique_constraint") == 1;
                Integer fillFactor = r.getInt("fill_factor");
                Boolean padded = r.getInt("is_padded") == 1;
                Boolean disabled = r.getInt("is_disabled") == 1;
                Boolean allowRowLocks = r.getInt("allow_row_locks") == 1;
                Boolean allowPageLocks = r.getInt("allow_page_locks") == 1;
                String filter = r.getString("filter_definition");
                Integer compression = r.getInt("data_compression");
                String partitionFunction = r.getString("partitionFunctionName");
                String partitionScheme = r.getString(PARTITION_SCHEME_PROP);
                if (fGroup != null) {
                    fGroup = cacheTypesAndSubTypes.computeIfAbsent(fGroup, k -> k);
                }
                SQLIndex six = new SQLIndex(name, object, primary, unique, type != null && (type.equals(1) || type.equals(5)));
                object.addIndex(six);
                six.setCustomProperties(new MapBuilder((Object)INDEX_ID_PROP, (Object)index_id).append((Object)TYPE_PROP, (Object)type).append((Object)IGNORE_DUP_PROP, (Object)ignore_dup).append((Object)UNIQUE_CONSTRAINT_PROP, (Object)uniqueConstraint).append((Object)FILL_FACTOR_PROP, (Object)fillFactor).append((Object)PADDED_PROP, (Object)padded).append((Object)DISABLED_PROP, (Object)disabled).append((Object)ALLOW_ROW_LOCKS_PROP, (Object)allowRowLocks).append((Object)ALLOW_PAGE_LOCKS_PROP, (Object)allowPageLocks).appendIfNotNull((Object)FILTER_PROP, (Object)filter).append((Object)COMPRESSION_PROP, (Object)compression).appendIfNotNull((Object)F_GROUP_PROP, (Object)fGroup).appendIfNotNull((Object)PARTITION_FUNCTION_PROP, (Object)partitionFunction).appendIfNotNull((Object)PARTITION_SCHEME_PROP, (Object)partitionScheme).append((Object)PARTITION_COLUMNS_PROP, new ArrayList()).build());
                if (type == null || !type.equals(4)) continue;
                Integer spatial_type = r.getInt(SPATIAL_INDEX_TYPE);
                String scheme = r.getString(SPATIAL_SCHEME);
                Integer bounding_box_xmin = this.getNullable(r, BOUNDING_BOX_XMIN);
                Integer bounding_box_ymin = this.getNullable(r, BOUNDING_BOX_YMIN);
                Integer bounding_box_xmax = this.getNullable(r, BOUNDING_BOX_XMAX);
                Integer bounding_box_ymax = this.getNullable(r, BOUNDING_BOX_YMAX);
                String level_1_grid_desc = r.getString(LEVEL_1_GRID_DESC);
                String level_2_grid_desc = r.getString(LEVEL_2_GRID_DESC);
                String level_3_grid_desc = r.getString(LEVEL_3_GRID_DESC);
                String level_4_grid_desc = r.getString(LEVEL_4_GRID_DESC);
                Integer cells_per_object = this.getNullable(r, CELLS_PER_OBJECT);
                Map<String, Object> m = six.getCustomProperties();
                m.put(SPATIAL_INDEX_TYPE, spatial_type);
                m.put(SPATIAL_SCHEME, cacheTypesAndSubTypes.computeIfAbsent(scheme, k -> k));
                if (bounding_box_xmin != null) {
                    m.put(BOUNDING_BOX_XMIN, bounding_box_xmin);
                    m.put(BOUNDING_BOX_YMIN, bounding_box_ymin);
                    m.put(BOUNDING_BOX_XMAX, bounding_box_xmax);
                    m.put(BOUNDING_BOX_YMAX, bounding_box_ymax);
                }
                if (level_1_grid_desc != null) {
                    m.put(LEVEL_1_GRID_DESC, cacheTypesAndSubTypes.computeIfAbsent(level_1_grid_desc, k -> k));
                    m.put(LEVEL_2_GRID_DESC, cacheTypesAndSubTypes.computeIfAbsent(level_2_grid_desc, k -> k));
                    m.put(LEVEL_3_GRID_DESC, cacheTypesAndSubTypes.computeIfAbsent(level_3_grid_desc, k -> k));
                    m.put(LEVEL_4_GRID_DESC, cacheTypesAndSubTypes.computeIfAbsent(level_4_grid_desc, k -> k));
                }
                m.put(CELLS_PER_OBJECT, cells_per_object);
            }
            r.close();
        } else if (resultSet == 3) {
            SQLObject object = null;
            int prev_object_id = -1;
            int prev_index_id = -1;
            List<ISQLColumn> cols = null;
            SQLIndex index = null;
            List partitions = null;
            while (r.next()) {
                object_id = r.getInt("object_id");
                Integer index_id = r.getInt(INDEX_ID_PROP);
                if (prev_object_id != object_id && object != null) {
                    object.finish();
                }
                if (prev_object_id != object_id || prev_index_id != index_id) {
                    object = this.objectMap.get(object_id);
                    prev_object_id = object_id;
                    prev_index_id = index_id;
                    index = null;
                    cols = null;
                    if (object == null || incr && (this.newlyLoadedObjects == null || !this.newlyLoadedObjects.containsKey(object_id)) || (cols = object.getColumns()) == null) continue;
                    for (SQLIndex six : object.getIndexes()) {
                        if (((Integer)six.getCustomProperties().get(INDEX_ID_PROP)).intValue() != index_id.intValue()) continue;
                        index = six;
                        break;
                    }
                    if (index == null) continue;
                    partitions = (List)index.getCustomProperties().get(PARTITION_COLUMNS_PROP);
                }
                if (cols == null || cols.size() == 0) continue;
                if (index == null) {
                    this.LOGGER.debug("This means index was null twice, probably due to nolocks {}, bailing out", (Object)object);
                    continue;
                }
                Integer column_id = r.getInt(COLUMN_ID_PROPERTY);
                Integer key_ordinal = r.getInt(KEY_ORDINAL_PROP);
                Integer partition_ordinal = r.getInt(PARTITION_ORDINAL_PROP);
                Boolean descending = r.getInt("is_descending_key") == 1;
                Boolean included = r.getInt("is_included_column") == 1;
                ISQLColumn col = null;
                try {
                    int size = cols.size();
                    if (size == cols.get(size - 1).getCustomProperty(COLUMN_ID_PROPERTY, 0)) {
                        col = cols.get(column_id - 1);
                    } else {
                        for (int i = Math.min(size - 1, column_id - 1); i >= 0; --i) {
                            if (!column_id.equals(cols.get(i).getCustomProperty(COLUMN_ID_PROPERTY, 0))) continue;
                            col = cols.get(i);
                            break;
                        }
                        if (col == null) {
                        }
                    }
                }
                catch (Exception e) {}
                continue;
                SQLSubObject indexColumn = new SQLSubObject(col.getName(), cacheTypesAndSubTypes.computeIfAbsent(col.getType(), k -> k));
                HashMap<String, Object> customs = new HashMap<String, Object>(4, 1.0f);
                indexColumn.setCustomProperties(customs);
                if (descending != null && descending.booleanValue()) {
                    customs.put(DESCENDING_PROP, descending);
                }
                customs.put(PARTITION_ORDINAL_PROP, partition_ordinal);
                customs.put(KEY_ORDINAL_PROP, key_ordinal);
                customs.put(SUBOBJECT_TYPE, (Object)SubObjectType.INDEX);
                if (partition_ordinal > 0) {
                    partitions.add(indexColumn);
                }
                Integer indexType = this.getIndexType(index, index_id, object_id, object);
                if (included.booleanValue() && (indexType == null || indexType != 6 && indexType != 5)) {
                    index.addIncluded(indexColumn);
                    continue;
                }
                if (key_ordinal <= 0 && indexType != 6 && indexType != 4) continue;
                index.addColumn(indexColumn);
            }
            r.close();
        }
        if (resultSet == 3) {
            try {
                String def = this.lastDate != null ? (this.major > 8 ? defaults.replace("[PLACEHOLDER]", "AND so.modify_date >= ''" + this.lastDate + "''") : defaults.replace("[PLACEHOLDER]", "AND so.refdate >= ''" + this.lastDate + "''")) : defaults.replace("[PLACEHOLDER]", "");
                this.options = this.createOptions();
                this.runSQL(def, this::processStoredProcedureResults, this.options);
            }
            catch (Exception e) {
                this.LOGGER.error("Error while loading storage", (Throwable)e);
            }
        }
    }

    private Integer getNullable(ResultSet r, String name) throws SQLException {
        Integer i = r.getInt(name);
        if (r.wasNull()) {
            i = null;
        }
        return i;
    }

    private Integer getIndexType(SQLIndex index, Integer index_id, int object_id, SQLObject object2) {
        if (index == null) {
            this.LOGGER.error("Index was unexpectedly null here: {} {} {}", new Object[]{index_id, object_id, object2});
            return 0;
        }
        Map<String, Object> customProperties = index.getCustomProperties();
        Integer ix = (Integer)customProperties.get(TYPE_PROP);
        if (ix == null) {
            this.LOGGER.error("Index type should never be null, but was for index: " + index.getName() + ", " + this);
            return 0;
        }
        return (int)ix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStoredProcedureResults(ResultSet r, int resultSet) throws SQLException {
        if (resultSet == 1) {
            while (r.next()) {
                Timestamp dt = r.getTimestamp("dt");
                this.lastDate = SIMPLE_DATE_FORMAT.format(dt.toLocalDateTime());
            }
            r.close();
        }
        if (resultSet == 2) {
            ArrayList procsToProcs = new ArrayList();
            try {
                int object_id_prev = -2147360192;
                SQLObject proc = null;
                StringBuilder sb = new StringBuilder();
                while (r.next()) {
                    int object_id = r.getInt("object_id");
                    if (object_id != object_id_prev) {
                        if (proc != null) {
                            this.processProcedure(sb.toString(), proc).ifPresent(procsToProcs::add);
                        }
                        sb.setLength(0);
                    }
                    object_id_prev = object_id;
                    proc = this.objectMap.get(object_id);
                    if (proc == null) continue;
                    sb.append(r.getString("definition"));
                }
                if (proc != null) {
                    this.processProcedure(sb.toString(), proc).ifPresent(procsToProcs::add);
                }
                r.close();
            }
            finally {
                this.setLoaded();
                if ("model".equals(this.sb.getDatabase()) && this.runner != null) {
                    this.runner.closeConnection();
                }
                if (procsToProcs.size() > 0) {
                    this.es.submit(() -> this.reprocessProcedureInfo(procsToProcs));
                }
            }
        }
    }

    private void reprocessProcedureInfo(List<ProcInformation> procsToProcs) {
        HashMap<Integer, List> tablesPerProc = new HashMap<Integer, List>();
        try {
            TSqlLexer lt = new TSqlLexer(null);
            TSqlParser tp = new TSqlParser(null);
            lt.removeErrorListeners();
            tp.removeErrorListeners();
            tp.setTrace(false);
            tp.setProfile(false);
            ((ParserATNSimulator)tp.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tp.setBuildParseTree(true);
            for (ProcInformation proc : procsToProcs) {
                CodePointCharStream s = CharStreams.fromString((String)proc.getDefinition());
                CaseChangingCharStreamUpper upper = new CaseChangingCharStreamUpper((CharStream)s);
                lt.setInputStream((IntStream)upper);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lt);
                tp.setTokenStream((TokenStream)tokens);
                Procedure file = new Procedure(tp.create_or_alter_procedure());
                if (file == null) continue;
                List<Tuple<Clause, ParserRuleContext>> clauses = ClauseUtility.getClauses((Scope)file, 999999999, false, TSqlParser.Create_tableContext.class);
                for (Tuple<Clause, ParserRuleContext> tup : clauses) {
                    ParserRuleContext cx = (ParserRuleContext)tup.second();
                    List tl = (List)cx.accept((ParseTreeVisitor)new CreateOrDeclareTableVisitor(null, this));
                    for (CreateTable t : tl) {
                        SQLObject so = SQLServerSQLService.getObjectFromCreateTable(this, t, -1);
                        if (so == null) continue;
                        tablesPerProc.computeIfAbsent(proc.getProcedureObject().getId(), x -> new ArrayList()).add(so);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while parsing procs", (Throwable)ex);
        }
        tablesPerProc.keySet().forEach(f -> this.speculativeObjects.compute((Integer)f, (x, y) -> new ArrayList()).addAll((Collection)tablesPerProc.get(f)));
    }

    private Optional<ProcInformation> processProcedure(String definition, SQLObject proc) {
        List<? extends ISQLColumn> params = proc.getParameters();
        Proc walker = new Proc();
        Proc procInfo = null;
        BasicSQLTokenizer.walk(definition, procInfo != null ? procInfo : walker);
        Map<String, String> defaults2 = walker.getVariableDefaults();
        if (defaults2 != null && defaults2.size() > 0) {
            this.OBJECT_DEFAULTS.put(proc.getId(), defaults2);
            block0: for (String param : defaults2.keySet()) {
                String df = defaults2.get(param);
                if (df == null) continue;
                for (ISQLColumn iSQLColumn : params) {
                    if (!iSQLColumn.getName().equalsIgnoreCase(param) || !(iSQLColumn instanceof SQLServerColumn)) continue;
                    ((SQLServerColumn)iSQLColumn).setDefaultValue(cacheTypesAndSubTypes.computeIfAbsent(df, k -> k));
                    continue block0;
                }
            }
        }
        if (procInfo != null && ((ProcInformation)((Object)procInfo)).isHasCreateTable()) {
            return Optional.of(procInfo);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLObject> getObjects(EntityName entity, boolean fuzzy, SQLObjectType ... types) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity.getServer()).append(".").append(entity.getDatabase()).append(".").append(entity.getSchema()).append(".").append(entity.getName()).append("-").append(fuzzy);
        List<SQLObjectType> asList = Arrays.asList(types);
        asList.sort(Comparator.comparing(e -> e.ordinal()));
        for (SQLObjectType type : asList) {
            sb.append("-");
            sb.append((Object)type);
        }
        String key = sb.toString();
        List<SQLObject> obs = null;
        Map<String, List<SQLObject>> map = this.cache;
        synchronized (map) {
            obs = this.cache.get(key);
            if (obs == null) {
                obs = this.getObjectsInternal(entity, fuzzy, types);
                if (entity.getOriginalName().length() > 3 || obs.size() < 10000) {
                    this.cache.put(key, obs);
                }
            }
        }
        return new ArrayList<SQLObject>(obs);
    }

    private List<SQLObject> getObjectsInternal(EntityName sqlName, boolean fuzzy, SQLObjectType ... objectTypes) {
        String fuzzyPattern = FilterHelper.getRegexFromString2(sqlName.getName());
        boolean sqlSchemaIsDboOrEmpty = sqlName.getSchema().equalsIgnoreCase("dbo") || sqlName.getSchema().isEmpty();
        return this.objects.parallelStream().filter(o -> sqlName.getSchema().length() == 0 && (fuzzy || o.getSchemaName().equals(this.defaultSchema)) || o.getSchemaName().equalsIgnoreCase(sqlName.getSchema()) || o.isSystemObject() && o.getSchemaName().equals("sys") && sqlSchemaIsDboOrEmpty && dbos.contains(o.getName())).filter(o -> {
            if (!fuzzy) {
                return o.getName().equalsIgnoreCase(sqlName.getName());
            }
            if (sqlName.getOriginalName().matches("\\d+")) {
                return o.getName().toLowerCase().startsWith(sqlName.getName());
            }
            return o.getName().matches(fuzzyPattern);
        }).filter(o -> objectTypes.length == 0 || o.ofType(objectTypes)).collect(Collectors.toList());
    }

    @Override
    public Optional<String> getObjectDefinition(SQLObject object, Consumer<Exception> onError) {
        String synDef = (String)this.getProperty(object, SYNONYM_NAME);
        if (synDef != null) {
            return Optional.of("CREATE SYNONYM " + ContextUtils.quoteIfNeeded(object.getSchemaName()) + "." + ContextUtils.quoteIfNeeded(object.getName()) + " FOR " + synDef);
        }
        if (object.getSQLType() == SQLObjectType.TABLE) {
            try {
                return Optional.ofNullable(ContextUtils.getObject(object, this));
            }
            catch (Exception ex) {
                this.LOGGER.error("Error while fetching definition of: " + object, (Throwable)ex);
                onError.accept(ex);
            }
        }
        return Optional.empty();
    }

    private <T> T getProperty(SQLObject so, String name) {
        if (so.getCustomProperties() != null) {
            return (T)so.getCustomProperties().get(name);
        }
        return null;
    }

    @Override
    public void getObjectDefinition(SQLObject object, Consumer<String> definitionConsumer, Consumer<Exception> onError) {
        try {
            if (object.isBuiltIn()) {
                onError.accept(new Exception("The built-in doesn't have a definition"));
                return;
            }
            String synDef = (String)this.getProperty(object, SYNONYM_NAME);
            if (synDef != null) {
                definitionConsumer.accept("CREATE SYNONYM " + ContextUtils.quoteIfNeeded(object.getSchemaName()) + "." + ContextUtils.quoteIfNeeded(object.getName()) + " FOR " + synDef);
                return;
            }
            if (object.getSQLType() == SQLObjectType.TABLE) {
                definitionConsumer.accept(ContextUtils.getObject(object, this));
                return;
            }
            String build = this.major >= 9 ? new SQLBuilder("SELECT definition FROM sys.all_sql_modules WHERE object_id = ").append(object.getId()).build() : new SQLBuilder("SELECT text AS definition FROM syscomments WHERE id = ").append(object.getId()).append(" order by colid ").build();
            this.options = this.createOptions();
            this.runSQL(build, (rs, n) -> {
                try {
                    StringBuilder def = new StringBuilder();
                    while (rs.next()) {
                        def.append(rs.getString("definition"));
                    }
                    if (def.length() == 0) {
                        if (!object.ofType(SQLObjectType.STORED_PROCEDURE) || object.getNativeType() == null || !object.getNativeType().equals(EXTENDED_PROCEDURE_TYPE)) {
                            this.LOGGER.warn("No resultset found, do something???");
                        }
                        onError.accept(new Exception("Definition not found"));
                        return;
                    }
                    String definition = def.toString();
                    if (this.createOrAlterSupported() && object.ofType(SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW)) {
                        definition = this.replaceCreateWithCreateAlter(definition);
                    }
                    this.postProcessObject(definition, object, definitionConsumer);
                }
                catch (Exception e) {
                    this.LOGGER.error("Fetching object definition failed", (Throwable)e);
                    onError.accept(e);
                }
            }, this.options);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while fetching definition", (Throwable)ex);
            onError.accept(ex);
        }
    }

    @Override
    public boolean isSameIdentifier(String name, String name2) {
        if (name2 == name) {
            return true;
        }
        if (name == null || name2 == null) {
            return false;
        }
        return this.getNormalizedIdentifier(name).equalsIgnoreCase(this.getNormalizedIdentifier(name2));
    }

    private void postProcessObject(String s, SQLObject so, Consumer<String> finalResult) {
        StringBuilder indexes = new StringBuilder();
        ContextUtils.getIndexes(indexes, so, true, this);
        if (indexes.length() > 0) {
            finalResult.accept(s + "\n\nGO" + indexes);
        } else {
            finalResult.accept(s);
        }
    }

    static SQLObjectType fromString(String type) {
        return TYPE_MAP.getOrDefault(type != null ? type.toUpperCase() : null, SQLObjectType.UNKNOWN);
    }

    private boolean createOrAlterSupported() {
        return this.major == 13 && this.spLevel >= 4000 || this.major > 13;
    }

    @Override
    public String getQuotedName(SQLObject so) {
        StringBuilder sb = new StringBuilder();
        if (so.getName().startsWith("#")) {
            return ContextUtils.quoteIfNeeded(so.getName());
        }
        sb.append(ContextUtils.quoteIfNeeded(so.getContext().getDatabase().getDatabase())).append(".");
        if (!StringUtils.isEmpty(so.getSchemaName())) {
            sb.append(ContextUtils.quoteIfNeeded(so.getSchemaName()));
        }
        sb.append(".");
        sb.append(ContextUtils.quoteIfNeeded(so.getName()));
        return sb.toString();
    }

    @Override
    public String getNormalizedIdentifier(String identifier) {
        if (identifier.startsWith("[") && identifier.endsWith("]")) {
            return identifier.substring(1, identifier.length() - 1).replace("]]", "]");
        }
        if (identifier.startsWith("'") && identifier.endsWith("'")) {
            return identifier.substring(1, identifier.length() - 1).replace("''", "'");
        }
        if (identifier.startsWith("\"") && identifier.endsWith("\"")) {
            return identifier.substring(1, identifier.length() - 1).replace("\"\"", "\"");
        }
        return identifier;
    }

    @Override
    public String getQuotedIdentifier(String identifier) {
        return ContextUtils.quoteIfNeeded(identifier);
    }

    private String replaceCreateWithCreateAlter(String definition) {
        StringBuilder sb = new StringBuilder(definition.length());
        List tokens = TSQLLexer.parse((String)definition);
        boolean createStarted = false;
        for (int i = 0; i < tokens.size(); ++i) {
            ISQLToken token = (ISQLToken)tokens.get(i);
            if (!createStarted && definition.substring(token.getStart(), token.getEnd() + 1).equalsIgnoreCase("CREATE")) {
                sb.append("CREATE OR ALTER");
                createStarted = true;
                continue;
            }
            if (createStarted) {
                if (token.getTokenType() == TokenType.WHITESPACE && token.getEnd() - token.getStart() == 2) {
                    String s = definition.substring(token.getStart(), token.getEnd() + 1);
                    if (s.equals("   ")) {
                        sb.append(" ");
                    } else {
                        sb.append(s);
                    }
                    if (i >= tokens.size() - 1) break;
                    sb.append(definition.substring(token.getEnd() + 1));
                    break;
                }
                sb.append(definition.substring(token.getStart()));
                break;
            }
            sb.append(definition.substring(token.getStart(), token.getEnd() + 1));
        }
        return sb.toString();
    }

    @Override
    protected IScriptRunner createRunner() throws SQLException {
        this.options = this.createOptions();
        return this.sb.getDb().createRunner(this.sb.getDatabase(), this.options);
    }

    @Override
    public boolean needsSchema(SQLObject object) {
        if (object.isBuiltIn()) {
            return false;
        }
        return ListUtils.in((Object)((Object)object.getSQLType()), (Object[])new SQLObjectType[]{SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.TABLE_FUNCTION}) || !Objects.equals(this.defaultSchema, object.getSchemaName());
    }

    @Override
    public char getParameterListStart(SQLObject so) {
        if (so.ofType(SQLObjectType.STORED_PROCEDURE)) {
            return ' ';
        }
        return '(';
    }

    @Override
    public char getParameterListEnd(SQLObject so) {
        if (so.ofType(SQLObjectType.STORED_PROCEDURE)) {
            return '\u0000';
        }
        return ')';
    }

    private static Map<String, SQLObjectType> createTypeMap() {
        return new MapBuilder((Object)TABLE_TYPE, (Object)SQLObjectType.TABLE).append((Object)SYSTEM_TABLE_TYPE, (Object)SQLObjectType.TABLE).append((Object)TABLE_FUNCTION_IF, (Object)SQLObjectType.INLINE_TABLE_FUNCTION).append((Object)TABLE_FUNCTION_TF, (Object)SQLObjectType.TABLE_FUNCTION).append((Object)SCALAR_FUNCTION_FN, (Object)SQLObjectType.SCALAR_FUNCTION).append((Object)PROCEDURE_TYPE, (Object)SQLObjectType.STORED_PROCEDURE).append((Object)CLR_PROCEDURE_TYPE, (Object)SQLObjectType.STORED_PROCEDURE).append((Object)VIEW_TYPE, (Object)SQLObjectType.VIEW).append((Object)EXTENDED_PROCEDURE_TYPE, (Object)SQLObjectType.STORED_PROCEDURE).append((Object)TABLE_TYPE_TYPE, (Object)SQLObjectType.TABLE_TYPE).append((Object)"TR", (Object)SQLObjectType.TRIGGER).append((Object)"FS", (Object)SQLObjectType.SCALAR_FUNCTION).append((Object)"AF", (Object)SQLObjectType.SCALAR_FUNCTION).append((Object)"FT", (Object)SQLObjectType.TABLE_FUNCTION).build();
    }

    @Override
    public void addObjectUsage(SQLObject object, Optional<IUsageObject> sub) {
        SQLObject obj = sub.isPresent() ? sub.get() : object;
        obj.getUsage().ifPresent(usage -> {
            String id = String.valueOf(object.getId());
            if (sub.isPresent()) {
                SubObjectType type = ((IUsageObject)sub.get()).getObjectType();
                String colId = ((IUsageObject)sub.get()).getUsageId();
                if (colId == null) {
                    return;
                }
                id = id + "_" + colId + "_" + (type != null ? type.getType() : SubObjectType.COLUMN.getType());
            }
            this.USAGES.computeIfAbsent(id, e -> usage);
            SQLObject so = object.ofType(SQLObjectType.DATABASE) ? (SQLObject)this.databases.stream().filter(f -> f.getId() == object.getId()).findFirst().orElse(null) : this.objectMap.get(object.getId());
            if (!sub.isPresent() && so != object && so != null) {
                so.setUsage((SQLObjectUsage)usage);
            }
            this.config.save();
        });
    }

    @Override
    public String getSchema() {
        return this.defaultSchema;
    }

    public Set<String> getBuiltInTypes() {
        return this.BUILT_IN_TYPES;
    }
}

