/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import com.sigge.filerunner.completion.domain.SubObjectType;
import com.sigge.filerunner.sql.sqlserver.FlagsEncoder;
import java.util.Optional;

public class SQLServerColumn
implements ISQLColumn {
    private String name;
    private String dataType;
    private Optional<SQLObjectUsage> usage;
    private int columnFlags;
    private int constraintsFlags;
    private String defaultValue;
    private String computedDefinition;
    private String collation;
    private short subObjectType;

    public SQLServerColumn(String name, String datatype, int columnFlags, int extendedFlags) {
        this.name = name;
        this.dataType = datatype;
        this.columnFlags = columnFlags;
        this.constraintsFlags = extendedFlags;
    }

    @Override
    public Optional<SQLObjectUsage> getUsage() {
        return this.usage == null ? Optional.empty() : this.usage;
    }

    @Override
    public void setUsage(SQLObjectUsage usage) {
        this.usage = Optional.ofNullable(usage);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.dataType;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public String getCollation() {
        return this.collation;
    }

    @Override
    public boolean isAutoIncrement() {
        return FlagsEncoder.getFlag(this.columnFlags, 2);
    }

    @Override
    public boolean isNullable() {
        return FlagsEncoder.getFlag(this.columnFlags, 1);
    }

    @Override
    public boolean isOutput() {
        return FlagsEncoder.getFlag(this.columnFlags, 8);
    }

    @Override
    public String getUsageId() {
        return String.valueOf(FlagsEncoder.columnId(this.columnFlags));
    }

    @Override
    public String getQuotedType() {
        int length = FlagsEncoder.length(this.columnFlags);
        if (length == 0) {
            return SQLServerColumn.quoteIfNeeded(this.dataType);
        }
        String pre = this.dataType.substring(0, this.dataType.length() - length);
        String post = this.dataType.substring(this.dataType.length() - length);
        return String.valueOf(SQLServerColumn.quoteIfNeeded(pre)) + post;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setComputedDefinition(String computedDefinition) {
        this.computedDefinition = computedDefinition;
    }

    @Override
    public String getDefault() {
        return this.defaultValue;
    }

    @Override
    public String getComputedDefinition() {
        return this.computedDefinition;
    }

    @Override
    public SubObjectType getObjectType() {
        return SubObjectType.fromType(this.subObjectType);
    }

    public void setObjectType(SubObjectType subObjectType) {
        this.subObjectType = (short)subObjectType.getType();
    }

    @Override
    public <T> T getCustomProperty(String property) {
        switch (property) {
            case "column_id": {
                return (T)Integer.valueOf(FlagsEncoder.columnId(this.columnFlags));
            }
        }
        return null;
    }

    @Override
    public <T> T getCustomProperty(String name, T defaultValue) {
        T t = this.getCustomProperty(name);
        return t == null ? defaultValue : t;
    }

    static String quoteIfNeeded(String quote) {
        if (!quote.matches("[A-Za-z_#][A-Za-z0-9_#@$]*") || quote.matches("[0-9]+")) {
            return SQLServerColumn.quotePart(quote);
        }
        return quote;
    }

    static String quotePart(String part) {
        return "[" + part.replaceAll("\\]", "\\]\\]") + "]";
    }

    @Override
    public boolean isPersisted() {
        return FlagsEncoder.getFlag(this.columnFlags, 4);
    }
}

