/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.core.DateUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLScriptBuilder {
    private final String sql;
    private List<String> replacements = new ArrayList<String>();
    private final Pattern PATTERN_PARAMS = Pattern.compile("(?<!\\$)(\\$\\d+)");

    public SQLScriptBuilder(String sql) {
        this.sql = sql;
    }

    public SQLScriptBuilder addRaw(String str) {
        this.replacements.add(str);
        return this;
    }

    public SQLScriptBuilder add(String param) {
        if (param == null) {
            this.addNull();
        } else {
            this.replacements.add("N'" + param.replace("'", "''") + "'");
        }
        return this;
    }

    public SQLScriptBuilder add(Integer param) {
        if (param == null) {
            this.addNull();
        } else {
            this.replacements.add(param.toString());
        }
        return this;
    }

    public SQLScriptBuilder add(Long param) {
        if (param == null) {
            this.addNull();
        } else {
            this.replacements.add(param.toString());
        }
        return this;
    }

    public SQLScriptBuilder add(Boolean param) {
        if (param == null) {
            this.addNull();
        } else {
            this.replacements.add(param != false ? "1" : "0");
        }
        return this;
    }

    public SQLScriptBuilder add(LocalDateTime ld) {
        if (ld == null) {
            this.addNull();
        } else {
            this.replacements.add("'" + DateUtils.formatLocalDate(ld) + "'");
        }
        return this;
    }

    public SQLScriptBuilder addNull() {
        this.replacements.add("NULL");
        return this;
    }

    public String build() {
        Matcher matcher = this.PATTERN_PARAMS.matcher(this.sql);
        StringBuffer sb = new StringBuffer();
        boolean i = false;
        while (matcher.find()) {
            int index = Integer.valueOf(matcher.group().substring(1));
            matcher.appendReplacement(sb, this.replacements.get(index));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

