/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

public class FlagsEncoder {
    private static final int FLAGS_SHIFT = 0;
    private static final int LENGTH_SHIFT = 8;
    private static final int COLUMN_SHIFT = 16;
    private static final int FLAGS_MASK = 255;
    private static final int LENGTH_MASK = 255;
    private static final int COLUMN_MASK = 65535;
    public static final int FLAG_NULLABLE = 1;
    public static final int FLAG_IDENTITY = 2;
    public static final int FLAG_PERSISTED = 4;
    public static final int FLAG_OUTPUT = 8;
    public static final int FLAG_RESERVED_4 = 16;
    public static final int FLAG_RESERVED_5 = 32;
    public static final int FLAG_RESERVED_6 = 64;
    public static final int FLAG_RESERVED_7 = 128;

    public static int encode(int column_id, int length, boolean nullable, boolean auto_inc, boolean persisted, boolean is_output) {
        return FlagsEncoder.encode(column_id, length, (nullable ? 1 : 0) + (auto_inc ? 2 : 0) + (persisted ? 4 : 0) + (is_output ? 8 : 0));
    }

    public static int encode(int columnId, int length, int flags) {
        if ((columnId & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("columnId out of range");
        }
        if ((length & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("length out of range");
        }
        if ((flags & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("flags out of range");
        }
        return columnId << 16 | length << 8 | flags;
    }

    public static int columnId(int v) {
        return v >>> 16 & 0xFFFF;
    }

    public static int length(int v) {
        return v >>> 8 & 0xFF;
    }

    public static int flags(int v) {
        return v & 0xFF;
    }

    public static boolean getFlag(int v, int flagMask) {
        return (v & 0xFF & flagMask) > 0;
    }
}

