/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseContext;
import com.siggemannen.core.MapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ContextUtils {
    public static final int TAB_SIZE = 8;

    static String quoteIfNeeded(String quote) {
        if (!quote.matches("[A-Za-z_#][A-Za-z0-9_#@$]*") || quote.matches("[0-9]+")) {
            return ContextUtils.quotePart(quote);
        }
        return quote;
    }

    static String quotePart(String part) {
        return "[" + part.replaceAll("\\]", "\\]\\]") + "]";
    }

    public static String getObject(SQLObject object, DatabaseContext context) {
        String lineSep = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(context.getQuotedName(object)).append(" (").append(lineSep);
        int maxTabs = StringUtils.maxLength(object.getColumns().stream().map(c -> ContextUtils.quoteIfNeeded(c.getName())));
        int maxTabsType = StringUtils.maxLength(object.getColumns().stream().map(c -> ContextUtils.getType(c)));
        int tabify = maxTabs / 8 + 1;
        int typeIfy = maxTabsType / 8 + 1;
        for (int col = 0; col < object.getColumns().size(); ++col) {
            String defaultC;
            if (col > 0) {
                sb.append(lineSep).append(",");
            }
            sb.append("\t");
            ISQLColumn column = object.getColumns().get(col);
            sb.append(StringUtils.tabify(ContextUtils.quoteIfNeeded(column.getName()), tabify, 8));
            sb.append(StringUtils.tabify(ContextUtils.getType(column), typeIfy, 8));
            String collation = (String)column.getCustomProperty("COLUMN_COLLATION");
            if (collation != null) {
                sb.append(" COLLATE ").append(collation);
            }
            if (column.getComputedDefinition() == null && !column.isNullable()) {
                sb.append(" NOT NULL");
            }
            if ((defaultC = column.getDefault()) != null) {
                sb.append(" DEFAULT ").append(defaultC);
            }
            if (!column.isAutoIncrement()) continue;
            sb.append(" IDENTITY");
        }
        String fileGroupForTable = "PRIMARY";
        String partitionSchemeForTable = null;
        String partitionColumnForTable = "";
        for (int i = 0; i < object.getIndexes().size(); ++i) {
            SQLIndex six = object.getIndexes().get(i);
            Map props = six.getCustomProperties();
            if (props == null) {
                props = Collections.EMPTY_MAP;
            }
            String fGroup = (String)props.get("fGroup");
            String partitionScheme = (String)props.get("partitionScheme");
            if (six.isClustered() || (Integer)props.get("index_id") == 0) {
                fileGroupForTable = fGroup;
                partitionSchemeForTable = partitionScheme;
                List partitionColumns = (List)props.get("partitionColumns");
                if (partitionColumns != null) {
                    Collections.sort(partitionColumns, Comparator.comparing(pk -> (Integer)pk.getCustomProperties().get().get("partition_ordinal")));
                    for (int j = 0; j < partitionColumns.size(); ++j) {
                        SQLSubObject colz = (SQLSubObject)partitionColumns.get(j);
                        if (j > 0) {
                            partitionColumnForTable = partitionColumnForTable + ",";
                        }
                        partitionColumnForTable = partitionColumnForTable + ContextUtils.quoteIfNeeded(colz.getName());
                    }
                }
            }
            if (!six.isPrimary()) continue;
            sb.append(lineSep).append(",");
            sb.append("\tCONSTRAINT ").append(ContextUtils.quoteIfNeeded(six.getName())).append(" PRIMARY KEY ").append(six.isClustered() ? "CLUSTERED" : "NONCLUSTERED").append("(");
            for (int j = 0; j < six.getColumns().size(); ++j) {
                sb.append(lineSep);
                SQLSubObject col = six.getColumns().get(j);
                if (j > 0) {
                    sb.append(",");
                }
                sb.append("\t").append(ContextUtils.quoteIfNeeded(col.getName()));
            }
            partitionScheme = (String)props.get("partitionScheme");
            String partitionCols = "";
            if (partitionScheme != null) {
                List partitionColumns = (List)props.get("partitionColumns");
                for (int j = 0; j < partitionColumns.size(); ++j) {
                    SQLSubObject colz = (SQLSubObject)partitionColumns.get(j);
                    if (j > 0) {
                        partitionCols = partitionCols + ",";
                    }
                    partitionCols = partitionCols + ContextUtils.quoteIfNeeded(colz.getName());
                }
            }
            sb.append(")");
            String s = ContextUtils.getIndexOptions(six);
            if (s != null) {
                sb.append(s);
            }
            if (partitionScheme == null && (fGroup == null || !(context instanceof SQLServerDatabaseContext))) continue;
            sb.append(" ON ").append(partitionScheme != null ? ContextUtils.quotePart(partitionScheme) + "(" + partitionCols + ")" : ContextUtils.quotePart(fGroup));
        }
        sb.append(lineSep).append(")");
        if (partitionSchemeForTable != null || fileGroupForTable != null && context instanceof SQLServerDatabaseContext) {
            sb.append(" ON ").append(partitionSchemeForTable != null ? ContextUtils.quotePart(partitionSchemeForTable) + "(" + partitionColumnForTable + ")" : ContextUtils.quotePart(fileGroupForTable));
        }
        ContextUtils.getIndexes(sb, object, true, context);
        return sb.toString();
    }

    private static <T> T getValue(SQLIndex six, String value) {
        Map<String, Object> customProperties = six.getCustomProperties();
        if (customProperties == null) {
            return null;
        }
        Object o = customProperties.get(value);
        return (T)o;
    }

    private static String getIndexOptions(SQLIndex six) {
        Integer compression;
        Map indexProps = new MapBuilder((Object)"padded", (Object)"PAD_INDEX").append((Object)"allowRowLocks", (Object)"ALLOW_ROW_LOCKS").append((Object)"allowPageLocks", (Object)"ALLOW_PAGE_LOCKS").append((Object)"compression", (Object)"DATA_COMPRESSION").append((Object)"fillFactor", (Object)"FILLFACTOR").build();
        ArrayList<String> strings = new ArrayList<String>();
        Map<String, Object> customProperties = six.getCustomProperties();
        Integer type = customProperties != null ? (Integer)customProperties.get("type") : 0;
        String pre = "";
        if (type.equals(4)) {
            String scheme = (String)customProperties.get("scheme");
            Integer bounding_box_xmin = (Integer)customProperties.get("bounding_box_xmin");
            Integer bounding_box_ymin = (Integer)customProperties.get("bounding_box_ymin");
            Integer bounding_box_xmax = (Integer)customProperties.get("bounding_box_xmax");
            Integer bounding_box_ymax = (Integer)customProperties.get("bounding_box_ymax");
            String level_1_grid_desc = (String)customProperties.get("level_1_grid_desc");
            String level_2_grid_desc = (String)customProperties.get("level_2_grid_desc");
            String level_3_grid_desc = (String)customProperties.get("level_3_grid_desc");
            String level_4_grid_desc = (String)customProperties.get("level_4_grid_desc");
            Integer cells_per_object = (Integer)customProperties.get("cells_per_object");
            pre = "USING " + scheme;
            if (bounding_box_ymin != null) {
                strings.add("BOUNDING_BOX = (" + bounding_box_xmin + "," + bounding_box_ymin + ", " + bounding_box_xmax + "," + bounding_box_ymax + ")");
            }
            if (level_1_grid_desc != null) {
                strings.add("GRIDS = (LEVEL_1 = " + level_1_grid_desc + ", LEVEL_2 = " + level_2_grid_desc + ", LEVEL_3 = " + level_3_grid_desc + ", LEVEL_4 = " + level_4_grid_desc + ")");
            }
            if (cells_per_object != null) {
                strings.add("CELLS_PER_OBJECT = " + cells_per_object);
            }
        }
        if (!type.equals(5) && !type.equals(6)) {
            Integer ff;
            Boolean p = (Boolean)ContextUtils.getValue(six, "padded");
            if (p != null && p.booleanValue()) {
                strings.add((String)indexProps.get("padded") + " = ON");
            }
            if ((p = (Boolean)ContextUtils.getValue(six, "allowRowLocks")) != null) {
                strings.add((String)indexProps.get("allowRowLocks") + " = " + (p != false ? "ON" : "OFF"));
            }
            if ((p = (Boolean)ContextUtils.getValue(six, "allowPageLocks")) != null) {
                strings.add((String)indexProps.get("allowPageLocks") + " = " + (p != false ? "ON" : "OFF"));
            }
            if ((ff = (Integer)ContextUtils.getValue(six, "fillFactor")) != null && !ff.equals(0)) {
                strings.add("FILLFACTOR = " + ff);
            }
        }
        if ((compression = (Integer)ContextUtils.getValue(six, "compression")) != null && compression > 0) {
            String dc = "DATA_COMPRESSION = ";
            switch (compression) {
                case 1: {
                    dc = dc + "ROW";
                    break;
                }
                case 2: {
                    dc = dc + "PAGE";
                    break;
                }
                case 3: {
                    dc = dc + "COLUMNSTORE";
                    break;
                }
                case 4: {
                    dc = dc + "COLUMNSTORE_ARCHIVE";
                    break;
                }
                default: {
                    dc = dc + "UNKNOWN??";
                }
            }
            strings.add(dc);
        }
        if (strings.size() > 0) {
            StringBuilder ss = new StringBuilder(pre).append(" WITH (");
            for (int i = 0; i < strings.size(); ++i) {
                if (i > 0) {
                    ss.append(", ");
                }
                ss.append((String)strings.get(i));
            }
            ss.append(")");
            return ss.toString();
        }
        return null;
    }

    public static StringBuilder getIndexes(StringBuilder sb, SQLObject object, boolean excludeMainIndex, DatabaseContext context) {
        String lineSep = System.lineSeparator();
        for (int i = 0; i < object.getIndexes().size(); ++i) {
            int type;
            SQLIndex six = object.getIndexes().get(i);
            if (six.isPrimary() || (Integer)six.getCustomProperties().get("index_id") == 0) continue;
            String fGroup = (String)six.getCustomProperties().get("fGroup");
            sb.append(lineSep).append(lineSep);
            sb.append("CREATE");
            if (six.isUnique()) {
                sb.append(" UNIQUE");
            }
            if ((type = ((Integer)six.getCustomProperties().get("type")).intValue()) == 4) {
                sb.append(" SPATIAL ");
            } else {
                sb.append(six.isClustered() ? " CLUSTERED" : " NONCLUSTERED");
            }
            if (type == 5 || type == 6) {
                sb.append(" COLUMNSTORE");
            }
            sb.append(" INDEX ").append(ContextUtils.quoteIfNeeded(six.getName())).append(" ON ").append(context.getQuotedName(object));
            if (type != 5) {
                sb.append(" ( ");
                for (int z = 0; z < six.getColumns().size(); ++z) {
                    SQLSubObject col = six.getColumns().get(z);
                    sb.append(lineSep);
                    if (z > 0) {
                        sb.append(",");
                    }
                    sb.append("\t").append(ContextUtils.quoteIfNeeded(col.getName()));
                    if (!((Boolean)col.getCustomProperties().map(f -> f.get("descending")).orElse(false)).booleanValue()) continue;
                    sb.append(" DESC");
                }
                sb.append(lineSep).append(")");
            }
            for (int inc = 0; inc < six.getIncludeColumns().size(); ++inc) {
                if (inc == 0) {
                    sb.append("\tINCLUDE (").append(lineSep);
                } else {
                    sb.append(lineSep).append(",");
                }
                sb.append("\t").append(ContextUtils.quoteIfNeeded(six.getIncludeColumns().get(inc).getName()));
                if (inc + 1 != six.getIncludeColumns().size()) continue;
                sb.append(lineSep).append(")");
            }
            sb.append(six.getCustomProperties().get("filter") != null ? " WHERE " + six.getCustomProperties().get("filter") : "");
            String options = ContextUtils.getIndexOptions(six);
            if (options != null) {
                sb.append(options);
            }
            String partitionScheme = (String)six.getCustomProperties().get("partitionScheme");
            String partitionCols = "";
            if (!(context instanceof SQLServerDatabaseContext)) continue;
            if (partitionScheme != null) {
                List partitionColumns = (List)six.getCustomProperties().get("partitionColumns");
                for (int j = 0; j < partitionColumns.size(); ++j) {
                    SQLSubObject colz = (SQLSubObject)partitionColumns.get(j);
                    if (j > 0) {
                        partitionCols = partitionCols + ",";
                    }
                    partitionCols = partitionCols + ContextUtils.quoteIfNeeded(colz.getName());
                }
                sb.append(" ON ").append(ContextUtils.quotePart(partitionScheme) + "(" + partitionCols + ")");
                continue;
            }
            if (fGroup == null) continue;
            sb.append(" ON ").append(ContextUtils.quotePart(fGroup));
        }
        return sb;
    }

    public static String getType(ISQLColumn column) {
        StringBuilder sb = new StringBuilder();
        if (column.getComputedDefinition() != null) {
            sb.append(" AS ");
            sb.append(column.getComputedDefinition());
            if (column.isPersisted()) {
                sb.append(" PERSISTED");
            }
            return sb.toString();
        }
        return column.getType();
    }
}

